/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromFiles;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCDataToSignHelperBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;

public abstract class ASiCWithCAdESDataToSignHelperBuilder
extends AbstractASiCDataToSignHelperBuilder {
    public GetDataToSignASiCWithCAdESHelper build(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        if (Utils.isCollectionNotEmpty((asicContent = ASiCUtils.ensureMimeTypeAndZipComment(asicContent, parameters.aSiC())).getSignatureDocuments()) || Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments())) {
            ASiCContainerType currentContainerType = asicContent.getContainerType();
            boolean asice = ASiCUtils.isASiCE(parameters.aSiC());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                DSSDocument manifestDocument = this.createManifestDocument(asicContent, parameters);
                return new DataToSignASiCEWithCAdESHelper(asicContent, manifestDocument, parameters.aSiC());
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                if (Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments()) || Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments())) {
                    return new DataToSignASiCSWithCAdESFromArchive(asicContent, parameters.aSiC());
                }
                return new DataToSignASiCSWithCAdESFromFiles(asicContent, parameters.aSiC());
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", new Object[]{currentContainerType, parameters.aSiC().getContainerType()}));
        }
        return this.fromFiles(asicContent, parameters);
    }

    private GetDataToSignASiCWithCAdESHelper fromFiles(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        if (ASiCUtils.isASiCE(parameters.aSiC())) {
            DSSDocument manifestDocument = this.createManifestDocument(asicContent, parameters);
            return new DataToSignASiCEWithCAdESHelper(asicContent, manifestDocument, parameters.aSiC());
        }
        DSSDocument asicsSignedDocument = this.getASiCSSignedDocument(asicContent.getSignedDocuments(), parameters.getZipCreationDate(), parameters.aSiC());
        asicContent.setSignedDocuments(Collections.singletonList(asicsSignedDocument));
        return new DataToSignASiCSWithCAdESFromFiles(asicContent, parameters.aSiC());
    }

    private DSSDocument createManifestDocument(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        return this.getManifestBuilder(asicContent, parameters).build();
    }

    protected abstract ASiCEWithCAdESManifestBuilder getManifestBuilder(ASiCContent var1, ASiCWithCAdESCommonParameters var2);
}

