/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asics;

import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class DataToSignASiCSWithCAdESFromArchive
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    public DataToSignASiCSWithCAdESFromArchive(ASiCContent asicContent, ASiCParameters asicParameters) {
        super(asicContent, asicParameters);
    }

    @Override
    public DSSDocument getToBeSigned() {
        List<DSSDocument> embeddedSignatures = this.asicContent.getSignatureDocuments();
        int nbEmbeddedSignatures = Utils.collectionSize(embeddedSignatures);
        if (nbEmbeddedSignatures != 1) {
            throw new DSSException("Unable to select the embedded signature (nb found:" + nbEmbeddedSignatures + ")");
        }
        return embeddedSignatures.get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        List<DSSDocument> embeddedSignedFiles = this.asicContent.getSignedDocuments();
        int nbSignedFiles = Utils.collectionSize(embeddedSignedFiles);
        if (nbSignedFiles != 1) {
            throw new DSSException("Unable to select the document to be signed (nb found:" + nbSignedFiles + ")");
        }
        return embeddedSignedFiles;
    }
}

