/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.scope;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.DetachedTimestampScopeFinder;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESTimestampScopeFinder
extends DetachedTimestampScopeFinder {
    private List<DSSDocument> containerDocuments;
    private List<DSSDocument> archiveDocuments;

    public void setContainerDocuments(List<DSSDocument> containerDocuments) {
        this.containerDocuments = containerDocuments;
    }

    public void setArchiveDocuments(List<DSSDocument> archiveDocuments) {
        this.archiveDocuments = archiveDocuments;
    }

    @Override
    public List<SignatureScope> findTimestampScope(TimestampToken timestampToken) {
        if (timestampToken.isMessageImprintDataIntact().booleanValue()) {
            if (timestampToken.getManifestFile() != null) {
                return this.getTimestampSignatureScopeForManifest(timestampToken.getManifestFile());
            }
            return this.getTimestampSignatureScopeForDocument(this.timestampedData);
        }
        return Collections.emptyList();
    }

    private List<SignatureScope> getTimestampSignatureScopeForManifest(ManifestFile manifestFile) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add(new ManifestSignatureScope(manifestFile.getFilename(), this.getDigest(manifestFile.getDocument())));
        if (Utils.isCollectionNotEmpty(this.containerDocuments)) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (!manifestEntry.isIntact()) continue;
                for (DSSDocument document : this.containerDocuments) {
                    if (!Utils.areStringsEqual(manifestEntry.getFileName(), document.getName())) continue;
                    result.addAll(this.getTimestampSignatureScopeForDocument(document));
                }
            }
        }
        return result;
    }

    @Override
    protected List<SignatureScope> getTimestampSignatureScopeForDocument(DSSDocument document) {
        if (ASiCUtils.isASiCSArchive(document)) {
            return this.getTimestampSignatureScopeForZipPackage(document);
        }
        return super.getTimestampSignatureScopeForDocument(document);
    }

    private List<SignatureScope> getTimestampSignatureScopeForZipPackage(DSSDocument document) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add(new ContainerSignatureScope(document.getName(), this.getDigest(document)));
        if (Utils.isCollectionNotEmpty(this.archiveDocuments)) {
            for (DSSDocument archivedDocument : this.archiveDocuments) {
                result.add(new ContainerContentSignatureScope(DSSUtils.decodeURI(archivedDocument.getName()), this.getDigest(archivedDocument)));
            }
        }
        return result;
    }
}

