/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.ASiCEWithXAdESManifestBuilder;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignASiCEWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignOpenDocumentHelper;
import eu.europa.esig.dss.asic.xades.signature.asics.DataToSignASiCSWithXAdESHelper;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class ASiCWithXAdESDataToSignHelperBuilder
extends AbstractASiCDataToSignHelperBuilder {
    private static final String ZIP_ENTRY_ASICE_METAINF_MANIFEST = "META-INF/manifest.xml";

    public GetDataToSignASiCWithXAdESHelper build(ASiCContent asicContent, ASiCWithXAdESSignatureParameters parameters) {
        if (ASiCUtils.isOpenDocument((asicContent = ASiCUtils.ensureMimeTypeAndZipComment(asicContent, parameters.aSiC())).getMimeTypeDocument())) {
            return new DataToSignOpenDocumentHelper(asicContent, parameters.aSiC());
        }
        if (Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments())) {
            ASiCContainerType currentContainerType = asicContent.getContainerType();
            boolean asice = ASiCUtils.isASiCE(parameters.aSiC());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                return new DataToSignASiCEWithXAdESHelper(asicContent, parameters.aSiC());
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                return new DataToSignASiCSWithXAdESHelper(asicContent, parameters.aSiC());
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", new Object[]{currentContainerType, parameters.aSiC().getContainerType()}));
        }
        return this.fromFiles(asicContent, parameters);
    }

    private GetDataToSignASiCWithXAdESHelper fromFiles(ASiCContent asicContent, ASiCWithXAdESSignatureParameters parameters) {
        if (ASiCUtils.isASiCE(parameters.aSiC())) {
            DSSDocument asicManifest = this.createASiCManifest(asicContent.getSignedDocuments());
            asicContent.getManifestDocuments().add(asicManifest);
            return new DataToSignASiCEWithXAdESHelper(asicContent, parameters.aSiC());
        }
        DSSDocument asicsSignedDocument = this.getASiCSSignedDocument(asicContent.getSignedDocuments(), parameters.bLevel().getSigningDate(), parameters.aSiC());
        asicContent.setSignedDocuments(Collections.singletonList(asicsSignedDocument));
        return new DataToSignASiCSWithXAdESHelper(asicContent, parameters.aSiC());
    }

    private DSSDocument createASiCManifest(List<DSSDocument> documents) {
        ASiCEWithXAdESManifestBuilder manifestBuilder = new ASiCEWithXAdESManifestBuilder(documents);
        return DomUtils.createDssDocumentFromDomDocument(manifestBuilder.build(), ZIP_ENTRY_ASICE_METAINF_MANIFEST);
    }
}

