/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESASiCContentBuilder;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESCounterSignatureHelper;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESCounterSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCWithXAdESService
extends AbstractASiCSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters, XAdESCounterSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithXAdESService.class);

    public ASiCWithXAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with XAdES created");
    }

    @Override
    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        ASiCContent asicContent = new ASiCWithXAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithXAdESHelper getDataToSignHelper = new ASiCWithXAdESDataToSignHelperBuilder().build(asicContent, parameters);
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, asicContent.getSignatureDocuments(), getDataToSignHelper.isOpenDocument());
        return this.getXAdESService().getContentTimestamp(getDataToSignHelper.getToBeSigned(), xadesParameters);
    }

    @Override
    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        this.assertSigningCertificateValid(parameters);
        ASiCContent asicContent = new ASiCWithXAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = new ASiCWithXAdESDataToSignHelperBuilder().build(asicContent, parameters);
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, asicContent.getSignatureDocuments(), dataToSignHelper.isOpenDocument());
        return this.getXAdESService().getDataToSign(dataToSignHelper.getToBeSigned(), xadesParameters);
    }

    @Override
    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        this.assertSigningCertificateValid(parameters);
        ASiCContent asicContent = new ASiCWithXAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = new ASiCWithXAdESDataToSignHelperBuilder().build(asicContent, parameters);
        XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, asicContent.getSignatureDocuments(), dataToSignHelper.isOpenDocument());
        DSSDocument newSignature = this.getXAdESService().signDocument(dataToSignHelper.getToBeSigned(), xadesParameters, signatureValue);
        String newSignatureFilename = dataToSignHelper.getSignatureFilename();
        newSignature.setName(newSignatureFilename);
        ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), newSignature);
        DSSDocument asicSignature = this.buildASiCContainer(asicContent, parameters.bLevel().getSigningDate());
        asicSignature.setName(this.getFinalDocumentName(asicSignature, SigningOperation.SIGN, parameters.getSignatureLevel(), asicSignature.getMimeType()));
        parameters.reinit();
        return asicSignature;
    }

    @Override
    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, XAdESTimestampParameters parameters) {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-S/E + XAdES");
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        this.assertExtensionSupported(toExtendDocument);
        ASiCContent asicContent = this.extractCurrentArchive(toExtendDocument);
        List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
        this.assertValidSignaturesToExtendFound(signatureDocuments);
        boolean openDocument = ASiCUtils.isOpenDocument(asicContent.getMimeTypeDocument());
        List<DSSDocument> detachedContents = this.getDetachedContents(asicContent, openDocument);
        for (DSSDocument signature : signatureDocuments) {
            XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, Collections.emptyList(), openDocument);
            xadesParameters.setDetachedContents(detachedContents);
            DSSDocument extendedDocument = this.getXAdESService().extendDocument(signature, xadesParameters);
            extendedDocument.setName(signature.getName());
            ASiCUtils.addOrReplaceDocument(signatureDocuments, extendedDocument);
        }
        DSSDocument extensionResult = this.buildASiCContainer(asicContent, parameters.bLevel().getSigningDate());
        extensionResult.setName(this.getFinalDocumentName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), toExtendDocument.getMimeType()));
        return extensionResult;
    }

    private void assertExtensionSupported(DSSDocument toExtendDocument) {
        if (!ASiCUtils.isZip(toExtendDocument)) {
            throw new IllegalInputException("Unsupported file type");
        }
    }

    private void assertValidSignaturesToExtendFound(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No supported signature documents found! Unable to extend the container.");
        }
    }

    protected List<DSSDocument> getDetachedContents(ASiCContent asicContent, boolean isOpenDocument) {
        if (isOpenDocument) {
            return OpenDocumentSupportUtils.getOpenDocumentCoverage(asicContent);
        }
        return asicContent.getSignedDocuments();
    }

    protected XAdESService getXAdESService() {
        XAdESService xadesService = new XAdESService(this.certificateVerifier);
        xadesService.setTspSource(this.tspSource);
        return xadesService;
    }

    private XAdESSignatureParameters getXAdESParameters(ASiCWithXAdESSignatureParameters parameters, List<DSSDocument> signatureDocuments, boolean openDocument) {
        Document rootDocument;
        parameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        if (Utils.isCollectionNotEmpty(signatureDocuments) && (ASiCContainerType.ASiC_S.equals((Object)parameters.aSiC().getContainerType()) || openDocument)) {
            if (Utils.collectionSize(signatureDocuments) > 1) {
                throw new IllegalInputException("Unable to choose signature file to add a new signature into! Only one signature file shall be present for the particular container format.");
            }
            DSSDocument existingXAdESSignature = signatureDocuments.iterator().next();
            if (!DomUtils.isDOM(existingXAdESSignature)) {
                throw new IllegalInputException(String.format("The provided signature file '%s' is not a valid XML! Unable to sign.", existingXAdESSignature.getName()));
            }
            rootDocument = DomUtils.buildDOM(existingXAdESSignature);
        } else {
            rootDocument = this.buildDomRoot(openDocument);
        }
        parameters.setRootDocument(rootDocument);
        return parameters;
    }

    private Document buildDomRoot(boolean openDocument) {
        Document rootDocument = DomUtils.buildDOM();
        Element xadesSignatures = openDocument ? rootDocument.createElementNS("urn:oasis:names:tc:opendocument:xmlns:digitalsignature:1.0", "document-signatures") : DomUtils.createElementNS(rootDocument, ASiCNamespace.NS, ASiCElement.XADES_SIGNATURES);
        rootDocument.appendChild(xadesSignatures);
        return rootDocument;
    }

    @Override
    protected AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithXAdESContainerExtractor(archive);
    }

    @Override
    protected String getExpectedSignatureExtension() {
        return ".xml";
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument asicContainer, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(asicContainer, "The asicContainer cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        ASiCContent asicContent = this.extractCurrentArchive(asicContainer);
        this.assertAddSignaturePolicyStorePossible(asicContent);
        XAdESService xadesService = this.getXAdESService();
        List<DSSDocument> signatureDocuments = asicContent.getSignatureDocuments();
        for (DSSDocument signature : signatureDocuments) {
            DSSDocument signatureWithPolicyStore = xadesService.addSignaturePolicyStore(signature, signaturePolicyStore);
            signatureWithPolicyStore.setName(signature.getName());
            ASiCUtils.addOrReplaceDocument(signatureDocuments, signatureWithPolicyStore);
        }
        DSSDocument resultArchive = this.buildASiCContainer(asicContent, null);
        resultArchive.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_SIG_POLICY_STORE, asicContainer.getMimeType()));
        return resultArchive;
    }

    @Override
    public ToBeSigned getDataToBeCounterSigned(DSSDocument asicContainer, XAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithXAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithXAdESCounterSignatureHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        XAdESService xadesService = this.getXAdESService();
        return xadesService.getDataToBeCounterSigned(signatureDocument, parameters);
    }

    @Override
    public DSSDocument counterSignSignature(DSSDocument asicContainer, XAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithXAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithXAdESCounterSignatureHelper(asicContainer);
        ASiCContent asicContent = counterSignatureHelper.getAsicContent();
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        XAdESService xadesService = this.getXAdESService();
        DSSDocument counterSignedSignature = xadesService.counterSignSignature(signatureDocument, parameters, signatureValue);
        counterSignedSignature.setName(signatureDocument.getName());
        ASiCUtils.addOrReplaceDocument(asicContent.getSignatureDocuments(), counterSignedSignature);
        DSSDocument resultArchive = this.buildASiCContainer(asicContent, parameters.bLevel().getSigningDate());
        resultArchive.setName(this.getFinalDocumentName(asicContainer, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        return resultArchive;
    }

    static {
        DomUtils.registerNamespace(ASiCNamespace.NS);
        DomUtils.registerNamespace(ManifestNamespace.NS);
    }
}

