/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.asic.xades.definition.ManifestPaths;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ASiCEWithXAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithXAdESManifestParser.class);
    private final DSSDocument signatureDocument;
    private final DSSDocument manifestDocument;

    public ASiCEWithXAdESManifestParser(DSSDocument signatureDocument, DSSDocument manifestDocument) {
        this.signatureDocument = signatureDocument;
        this.manifestDocument = manifestDocument;
    }

    public ManifestFile getManifest() {
        ManifestFile manifest = new ManifestFile();
        manifest.setDocument(this.manifestDocument);
        manifest.setSignatureFilename(this.signatureDocument.getName());
        manifest.setEntries(this.getEntries());
        return manifest;
    }

    private List<ManifestEntry> getEntries() {
        if (!DomUtils.isDOM(this.manifestDocument)) {
            LOG.warn("Unable to parse manifest file '{}': the document is not a valid XML!", (Object)this.manifestDocument.getName());
            return Collections.emptyList();
        }
        ArrayList<ManifestEntry> result = new ArrayList<ManifestEntry>();
        try {
            Document manifestDom = DomUtils.buildDOM(this.manifestDocument);
            DSSNamespace manifestNamespace = this.getManifestNamespace(manifestDom);
            DomUtils.registerNamespace(manifestNamespace);
            NodeList nodeList = DomUtils.getNodeList(manifestDom, ManifestPaths.FILE_ENTRY_PATH);
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    ManifestEntry manifestEntry = new ManifestEntry();
                    Element fileEntryElement = (Element)nodeList.item(i);
                    String fullpathValue = fileEntryElement.getAttribute(ManifestPaths.getFullPathAttribute(manifestNamespace));
                    if (this.isFolder(fullpathValue)) continue;
                    manifestEntry.setFileName(fullpathValue);
                    manifestEntry.setMimeType(this.getMimeType(fileEntryElement, manifestNamespace));
                    result.add(manifestEntry);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to parse manifest file '{}' : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, this.manifestDocument.getName(), e.getMessage(), e);
            }
            LOG.warn(errorMessage, (Object)this.manifestDocument.getName(), (Object)e.getMessage());
        }
        return result;
    }

    private DSSNamespace getManifestNamespace(Document manifestDom) {
        DSSNamespace manifestNamespace = DomUtils.browseRecursivelyForNamespaceWithUri(manifestDom.getDocumentElement(), ManifestNamespace.NS.getUri());
        return manifestNamespace != null ? manifestNamespace : ManifestNamespace.NS;
    }

    private MimeType getMimeType(Element fileEntryElement, DSSNamespace manifestNamespace) {
        String mediaType = fileEntryElement.getAttribute(ManifestPaths.getMediaTypeAttribute(manifestNamespace));
        if (Utils.isStringNotBlank(mediaType)) {
            return MimeType.fromMimeTypeString(mediaType);
        }
        return null;
    }

    private boolean isFolder(String fullpathValue) {
        return fullpathValue.endsWith("/");
    }

    static {
        DomUtils.registerNamespace(ManifestNamespace.NS);
    }
}

