/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignaturePolicyStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignaturePolicyStoreBuilder.class);

    public CMSSignedData addSignaturePolicyStore(CMSSignedData cmsSignedData, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData must be provided");
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSignaturePolicyContent(), "Signature policy content must be provided");
        Collection<SignerInformation> signerInformationCollection = cmsSignedData.getSignerInfos().getSigners();
        if (Utils.isCollectionEmpty(signerInformationCollection)) {
            throw new IllegalInputException("Unable to extend the document! No signatures found.");
        }
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationCollection) {
            this.assertSignaturePolicyStoreExtensionPossible(signerInformation);
            SignerInformation newSignerInformation = signerInformation;
            CAdESSignature cadesSignature = new CAdESSignature(cmsSignedData, signerInformation);
            SignaturePolicy signaturePolicy = cadesSignature.getSignaturePolicy();
            if (signaturePolicy != null) {
                signaturePolicy.setPolicyContent(signaturePolicyStore.getSignaturePolicyContent());
                Digest expectedDigest = signaturePolicy.getDigest();
                if (expectedDigest != null) {
                    SignaturePolicyValidator validator = new DefaultSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
                    Digest computedDigest = validator.getComputedDigest(signaturePolicyStore.getSignaturePolicyContent(), expectedDigest.getAlgorithm());
                    if (expectedDigest.equals(computedDigest)) {
                        newSignerInformation = this.addSignaturePolicyStore(signerInformation, signaturePolicyStore);
                    } else {
                        LOG.warn("Signature policy's digest doesn't match the document {} for signature {}", (Object)expectedDigest, (Object)cadesSignature.getId());
                    }
                } else {
                    LOG.warn("SignaturePolicyIdentifier Digest is not found for a signature with id {}", (Object)cadesSignature.getId());
                }
            } else {
                LOG.warn("SignaturePolicyIdentifier is not defined for a signature with id {}", (Object)cadesSignature.getId());
            }
            newSignerInformationList.add(newSignerInformation);
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        return CMSSignedData.replaceSigners(cmsSignedData, newSignerStore);
    }

    private SignerInformation addSignaturePolicyStore(SignerInformation signerInformation, SignaturePolicyStore signaturePolicyStore) {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        ASN1Sequence sigPolicyStore = this.getSignaturePolicyStore(signaturePolicyStore);
        AttributeTable unsignedAttributesWithPolicyStore = unsignedAttributes.add(OID.id_aa_ets_sigPolicyStore, sigPolicyStore);
        return SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributesWithPolicyStore);
    }

    private ASN1Sequence getSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        ASN1EncodableVector sigPolicyStore = new ASN1EncodableVector();
        sigPolicyStore.add(DSSASN1Utils.buildSPDocSpecificationId(signaturePolicyStore.getSpDocSpecification().getId()));
        sigPolicyStore.add(new DEROctetString(DSSUtils.toByteArray(signaturePolicyStore.getSignaturePolicyContent())));
        return new DERSequence(sigPolicyStore);
    }

    private void assertSignaturePolicyStoreExtensionPossible(SignerInformation signerInformation) {
        if (CMSUtils.containsATSTv2(signerInformation)) {
            throw new IllegalInputException("Cannot add signature policy store to a CAdES containing an archiveTimestampV2");
        }
    }
}

