/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.validation.SignatureProperties;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;

public abstract class CAdESSigProperties
implements SignatureProperties<CAdESAttribute> {
    private static final long serialVersionUID = -1730805576179343914L;
    private final AttributeTable attributeTable;

    CAdESSigProperties(AttributeTable attributeTable) {
        this.attributeTable = attributeTable;
    }

    @Override
    public boolean isExist() {
        return this.attributeTable != null;
    }

    @Override
    public List<CAdESAttribute> getAttributes() {
        ArrayList<CAdESAttribute> attributes = new ArrayList<CAdESAttribute>();
        if (this.isExist()) {
            ASN1EncodableVector asn1EncodableVector = this.attributeTable.toASN1EncodableVector();
            for (int ii = 0; ii < asn1EncodableVector.size(); ++ii) {
                Attribute attribute = (Attribute)asn1EncodableVector.get(ii);
                attributes.add(new CAdESAttribute(attribute));
            }
        }
        return attributes;
    }
}

