/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public abstract class JAdESExtensionBuilder {
    protected void assertEtsiUComponentsConsistent(JWS jws, boolean isBase64UrlEtsiUComponents) {
        List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
        if (Utils.isCollectionNotEmpty(etsiU)) {
            if (!DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                throw new IllegalInputException("Extension is not possible, because components of the 'etsiU' header have not common format! Shall be all Strings or Objects.");
            }
            if (DSSJsonUtils.areAllBase64UrlComponents(etsiU) != isBase64UrlEtsiUComponents) {
                throw new IllegalInputException(String.format("Extension is not possible! The encoding of 'etsiU' components shall match! Use jadesSignatureParameters.setBase64UrlEncodedEtsiUComponents(%s)", !isBase64UrlEtsiUComponents));
            }
        }
    }

    protected void assertJWSJsonSerializationObjectValid(JWSJsonSerializationObject jwsJsonSerializationObject) {
        if (jwsJsonSerializationObject == null) {
            throw new IllegalInputException("The provided document is not a valid JAdES signature! Unable to extend.");
        }
        if (Utils.isCollectionEmpty(jwsJsonSerializationObject.getSignatures())) {
            throw new IllegalInputException("There is no signature to extend!");
        }
        if (!jwsJsonSerializationObject.isValid()) {
            throw new IllegalInputException(String.format("Signature extension is not supported for invalid RFC 7515 files (shall be a Serializable JAdES signature). Reason(s) : %s", jwsJsonSerializationObject.getStructuralValidationErrors()));
        }
    }

    protected void assertJSONSerializationObjectMayBeExtended(JWSJsonSerializationObject jwsJsonSerializationObject) {
        this.assertJWSJsonSerializationObjectValid(jwsJsonSerializationObject);
        JWSSerializationType jwsSerializationType = jwsJsonSerializationObject.getJWSSerializationType();
        if (!JWSSerializationType.JSON_SERIALIZATION.equals((Object)jwsSerializationType) && !JWSSerializationType.FLATTENED_JSON_SERIALIZATION.equals((Object)jwsSerializationType)) {
            throw new IllegalInputException("The extended signature shall have JSON Serialization (or Flattened) type! Use JWSConverter to convert the signature.");
        }
    }
}

