/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.ObjectStatus;
import eu.europa.esig.dss.jaxb.common.exception.SecurityConfigurationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurator<F> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigurator.class);
    private final Map<String, Boolean> features = new HashMap<String, Boolean>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private StatusAlert securityExceptionAlert = new ExceptionOnStatusAlert();

    public void setSecurityExceptionAlert(StatusAlert securityExceptionAlert) {
        Objects.requireNonNull(securityExceptionAlert);
        this.securityExceptionAlert = securityExceptionAlert;
    }

    public AbstractConfigurator<F> enableFeature(String feature) {
        return this.setFeature(feature, true);
    }

    public AbstractConfigurator<F> disableFeature(String feature) {
        return this.setFeature(feature, false);
    }

    private AbstractConfigurator<F> setFeature(String feature, boolean value) {
        Objects.requireNonNull(feature, "The feature constraint cannot be null!");
        Boolean currentValue = this.features.get(feature);
        if (currentValue != null && currentValue != value) {
            LOG.warn("SECURITY : feature with the name [{}] changed from [{}] to [{}]", feature, currentValue, value);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("The feature {} = {} has been added to the configuration", (Object)feature, (Object)value);
        }
        this.features.put(feature, value);
        return this;
    }

    public AbstractConfigurator<F> setAttribute(String attribute, Object value) {
        Objects.requireNonNull(attribute, "The attribute constraint cannot be null!");
        Object currentValue = this.attributes.get(attribute);
        if (currentValue != null && currentValue.equals(value)) {
            LOG.warn("SECURITY : attribute with the name [{}] changed from [{}] to [{}]", attribute, currentValue, value);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("The attribute {} = {} has been added to the configuration", (Object)attribute, value);
        }
        this.attributes.put(attribute, value);
        return this;
    }

    public AbstractConfigurator<F> removeAttribute(String attribute) {
        Objects.requireNonNull(attribute, "The attribute constraint cannot be null!");
        if (this.attributes.containsKey(attribute)) {
            this.attributes.remove(attribute);
            LOG.warn("SECURITY : the attribute with name [{}] has been disabled", (Object)attribute);
        }
        return this;
    }

    protected void setSecurityFeatures(F factory) {
        ObjectStatus status = new ObjectStatus();
        for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
            try {
                this.setSecurityFeature(factory, entry.getKey(), entry.getValue());
            }
            catch (SecurityConfigurationException e) {
                status.addRelatedObjectIdentifierAndErrorMessage(entry.getKey(), e.getMessage());
            }
        }
        if (!status.isEmpty()) {
            status.setMessage("SECURITY : unable to set feature(s)!");
            this.securityExceptionAlert.alert(status);
        }
    }

    protected abstract void setSecurityFeature(F var1, String var2, Boolean var3) throws SecurityConfigurationException;

    protected void setSecurityAttributes(F factory) {
        ObjectStatus status = new ObjectStatus();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            try {
                this.setSecurityAttribute(factory, entry.getKey(), entry.getValue());
            }
            catch (SecurityConfigurationException e) {
                status.addRelatedObjectIdentifierAndErrorMessage(entry.getKey(), e.getMessage());
            }
        }
        if (!status.isEmpty()) {
            status.setMessage("SECURITY : unable to set attribute(s)!");
            this.securityExceptionAlert.alert(status);
        }
    }

    protected abstract void setSecurityAttribute(F var1, String var2, Object var3) throws SecurityConfigurationException;
}

