/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb.common;

import eu.europa.esig.dss.jaxb.common.AbstractFactoryBuilder;
import eu.europa.esig.dss.jaxb.common.exception.SecurityConfigurationException;
import javax.xml.transform.TransformerFactory;

public class TransformerFactoryBuilder
extends AbstractFactoryBuilder<TransformerFactory> {
    protected TransformerFactoryBuilder() {
        this.enableFeature("http://javax.xml.XMLConstants/feature/secure-processing");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    public static TransformerFactoryBuilder getSecureTransformerBuilder() {
        return new TransformerFactoryBuilder();
    }

    public TransformerFactory build() {
        TransformerFactory transformerFactory = this.instantiateFactory();
        this.setSecurityFeatures(transformerFactory);
        this.setSecurityAttributes(transformerFactory);
        return transformerFactory;
    }

    @Override
    protected TransformerFactory instantiateFactory() {
        return TransformerFactory.newInstance();
    }

    public TransformerFactoryBuilder enableFeature(String feature) {
        return (TransformerFactoryBuilder)super.enableFeature(feature);
    }

    public TransformerFactoryBuilder disableFeature(String feature) {
        return (TransformerFactoryBuilder)super.disableFeature(feature);
    }

    public TransformerFactoryBuilder setAttribute(String attribute, Object value) {
        return (TransformerFactoryBuilder)super.setAttribute(attribute, value);
    }

    public TransformerFactoryBuilder removeAttribute(String attribute) {
        return (TransformerFactoryBuilder)super.removeAttribute(attribute);
    }

    @Override
    protected void setSecurityFeature(TransformerFactory factory, String feature, Boolean value) throws SecurityConfigurationException {
        try {
            factory.setFeature(feature, value);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException(e);
        }
    }

    @Override
    protected void setSecurityAttribute(TransformerFactory factory, String attribute, Object value) throws SecurityConfigurationException {
        try {
            factory.setAttribute(attribute, value);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException(e);
        }
    }
}

