/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pdf.PdfAnnotation;

public class AnnotationBox {
    private final float minX;
    private final float maxX;
    private final float minY;
    private final float maxY;

    public AnnotationBox(float minX, float minY, float maxX, float maxY) {
        this.minX = minX < maxX ? minX : maxX;
        this.minY = minY < maxY ? minY : maxY;
        this.maxX = minX < maxX ? maxX : minX;
        this.maxY = minY < maxY ? maxY : minY;
    }

    public AnnotationBox(SignatureFieldParameters fieldParameters) {
        this(fieldParameters.getOriginX(), fieldParameters.getOriginY(), fieldParameters.getOriginX() + fieldParameters.getWidth(), fieldParameters.getOriginY() + fieldParameters.getHeight());
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getWidth() {
        return this.maxX - this.minX;
    }

    public float getHeight() {
        return this.maxY - this.minY;
    }

    public AnnotationBox toPdfPageCoordinates(float pageHeight) {
        return new AnnotationBox(this.minX, pageHeight - this.maxY, this.maxX, pageHeight - this.minY);
    }

    public boolean isOverlap(PdfAnnotation pdfAnnotation) {
        return this.isOverlap(pdfAnnotation.getAnnotationBox());
    }

    public boolean isOverlap(AnnotationBox box) {
        if (this.getMinX() >= box.getMaxX() || box.getMinX() >= this.getMaxX()) {
            return false;
        }
        return !(this.getMinY() >= box.getMaxY()) && !(box.getMinY() >= this.getMaxY());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.maxX);
        result = 31 * result + Float.floatToIntBits(this.maxY);
        result = 31 * result + Float.floatToIntBits(this.minX);
        result = 31 * result + Float.floatToIntBits(this.minY);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationBox other = (AnnotationBox)obj;
        if (Float.floatToIntBits(this.maxX) != Float.floatToIntBits(other.maxX)) {
            return false;
        }
        if (Float.floatToIntBits(this.maxY) != Float.floatToIntBits(other.maxY)) {
            return false;
        }
        if (Float.floatToIntBits(this.minX) != Float.floatToIntBits(other.minX)) {
            return false;
        }
        return Float.floatToIntBits(this.minY) == Float.floatToIntBits(other.minY);
    }

    public String toString() {
        return "AnnotationBox [minX=" + this.minX + ", maxX=" + this.maxX + ", minY=" + this.minY + ", maxY=" + this.maxY + "]";
    }
}

