/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.encryption;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.encryption.SecureRandomProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.crypto.prng.FixedSecureRandom;

public class DSSSecureRandomProvider
implements SecureRandomProvider {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA512;
    private int binaryLength = 512;
    private PAdESCommonParameters parameters;

    public DSSSecureRandomProvider(PAdESCommonParameters parameters) {
        this.parameters = parameters;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setBinaryLength(int binaryLength) {
        if (binaryLength < 16) {
            throw new IllegalArgumentException("The binaryLength cannot be less then 16 bytes!");
        }
        this.binaryLength = binaryLength;
    }

    @Override
    public SecureRandom getSecureRandom() {
        byte[] seed = this.buildSeed();
        byte[] value = DSSUtils.digest(this.digestAlgorithm, seed);
        while (value.length < this.binaryLength) {
            value = DSSUtils.concatenate(value, value);
        }
        value = Utils.subarray(value, 0, this.binaryLength);
        return new FixedSecureRandom(value);
    }

    private byte[] buildSeed() {
        byte[] byArray;
        Objects.requireNonNull(this.parameters, "Parameters must be defined! Unable to use DSSFixedSecureRandomProvider.");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String subFilter;
            Date signingDate;
            String passwordProtection;
            SignatureImageParameters imageParameters;
            String filter;
            baos.write(this.parameters.getContentSize());
            DigestAlgorithm digestAlgorithm = this.parameters.getDigestAlgorithm();
            if (digestAlgorithm != null) {
                baos.write(digestAlgorithm.getName().getBytes());
            }
            if ((filter = this.parameters.getFilter()) != null) {
                baos.write(filter.getBytes());
            }
            if ((imageParameters = this.parameters.getImageParameters()) != null) {
                baos.write(imageParameters.toString().getBytes());
            }
            if ((passwordProtection = this.parameters.getPasswordProtection()) != null) {
                baos.write(passwordProtection.getBytes());
            }
            if ((signingDate = this.parameters.getSigningDate()) != null) {
                baos.write((int)signingDate.getTime());
            }
            if ((subFilter = this.parameters.getSubFilter()) != null) {
                baos.write(subFilter.getBytes());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to build a seed value. Reason : %s", e.getMessage()), e);
            }
        }
        baos.close();
        return byArray;
    }
}

