/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import java.io.IOException;
import java.io.InputStream;

public class MaxSizeInputStream
extends InputStream {
    private long maxSize;
    private InputStream wrappedStream;
    private String url;
    private long count = 0L;

    public MaxSizeInputStream(InputStream wrappedStream, long maxSize, String url) {
        this.maxSize = maxSize;
        this.wrappedStream = wrappedStream;
        this.url = url;
    }

    @Override
    public int read() throws IOException {
        if (this.maxSize != 0L) {
            ++this.count;
            if (this.count > this.maxSize) {
                throw new IOException("Cannot fetch data limit=" + this.maxSize + ", url =" + this.url);
            }
        }
        return this.wrappedStream.read();
    }
}

