/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.spi.x509.CertificateRefIdentifier;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.io.Serializable;

public class CertificateRef
implements IdentifierBasedObject,
Serializable {
    private static final long serialVersionUID = -325165164194282066L;
    private Digest certDigest;
    private SignerIdentifier signerIdentifier;
    private ResponderId responderId;
    private Identifier identifier;

    public Digest getCertDigest() {
        return this.certDigest;
    }

    public void setCertDigest(Digest certDigest) {
        this.certDigest = certDigest;
    }

    public SignerIdentifier getCertificateIdentifier() {
        return this.signerIdentifier;
    }

    public void setCertificateIdentifier(SignerIdentifier signerIdentifier) {
        this.signerIdentifier = signerIdentifier;
    }

    public ResponderId getResponderId() {
        return this.responderId;
    }

    public void setResponderId(ResponderId responderId) {
        this.responderId = responderId;
    }

    @Override
    public Identifier getDSSId() {
        if (this.identifier == null) {
            this.identifier = new CertificateRefIdentifier(this);
        }
        return this.identifier;
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public String toString() {
        return "CertificateRef [certDigest=" + this.certDigest + ", signerIdentifier=" + this.signerIdentifier + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateRef other = (CertificateRef)obj;
        return !(this.getDSSId() == null ? other.getDSSId() != null : !this.getDSSId().equals(other.getDSSId()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDSSId() == null ? 0 : this.getDSSId().hashCode());
        return result;
    }
}

