/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.client.jdbc.JdbcCacheConnector;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.RepositoryRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.sql.SQLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcRevocationSource<R extends Revocation>
extends RepositoryRevocationSource<R> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRevocationSource.class);
    private static final long serialVersionUID = 8752226611048306095L;
    protected transient JdbcCacheConnector jdbcCacheConnector;

    protected abstract String getCreateTableQuery();

    protected abstract String getTableExistenceQuery();

    protected abstract String getFindRevocationQuery();

    protected abstract String getDeleteTableQuery();

    protected abstract String getRemoveRevocationTokenEntryQuery();

    protected abstract RevocationToken<R> buildRevocationTokenFromResult(JdbcCacheConnector.JdbcResultRecord var1, CertificateToken var2, CertificateToken var3) throws DSSExternalResourceException;

    public void setJdbcCacheConnector(JdbcCacheConnector jdbcCacheConnector) {
        this.jdbcCacheConnector = jdbcCacheConnector;
    }

    @Override
    protected RevocationToken<R> findRevocation(String key, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        Collection<JdbcCacheConnector.JdbcResultRecord> records = this.jdbcCacheConnector.select(this.getFindRevocationQuery(), this.getRevocationDataExtractRequests(), key);
        LOG.debug("Record obtained : {}", (Object)records.size());
        if (records.size() == 1) {
            return this.buildRevocationTokenFromResult(records.iterator().next(), certificateToken, issuerCertificateToken);
        }
        return null;
    }

    protected abstract Collection<JdbcCacheConnector.JdbcResultRequest> getRevocationDataExtractRequests();

    @Override
    protected void removeRevocation(String revocationTokenKey) {
        this.jdbcCacheConnector.execute(this.getRemoveRevocationTokenEntryQuery(), revocationTokenKey);
    }

    public void initTable() throws SQLException {
        if (!this.isTableExists()) {
            LOG.debug("Table does not exist. Creating a new table...");
            this.createTable();
            LOG.info("Table was created.");
        } else {
            LOG.debug("Table already exists.");
        }
    }

    private void createTable() throws SQLException {
        this.jdbcCacheConnector.executeThrowable(this.getCreateTableQuery());
    }

    public boolean isTableExists() {
        return this.jdbcCacheConnector.tableQuery(this.getTableExistenceQuery());
    }

    public void destroyTable() throws SQLException {
        if (this.isTableExists()) {
            LOG.debug("Table exists. Removing the table...");
            this.dropTable();
            LOG.info("Table was destroyed.");
        } else {
            LOG.warn("Cannot drop the table. Table does not exist.");
        }
    }

    private void dropTable() throws SQLException {
        this.jdbcCacheConnector.executeThrowable(this.getDeleteTableQuery());
    }
}

