/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.download.XmlDownloadResult;
import eu.europa.esig.dss.tsl.download.XmlDownloadTask;
import eu.europa.esig.dss.tsl.parsing.LOTLParsingTask;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.validation.TLValidatorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnalysis.class);
    private final CacheAccessByKey cacheAccess;
    private final DSSFileLoader dssFileLoader;

    protected AbstractAnalysis(CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader) {
        this.cacheAccess = cacheAccess;
        this.dssFileLoader = dssFileLoader;
    }

    protected DSSDocument download(String url) {
        DSSDocument document = null;
        try {
            LOG.debug("Downloading url '{}'...", (Object)url);
            XmlDownloadTask downloadTask = new XmlDownloadTask(this.dssFileLoader, url);
            XmlDownloadResult downloadResult = downloadTask.get();
            if (!this.cacheAccess.isUpToDate(downloadResult)) {
                this.cacheAccess.update(downloadResult);
                this.cacheAccess.expireParsing();
                this.cacheAccess.expireValidation();
            }
            document = downloadResult.getDSSDocument();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            this.cacheAccess.downloadError(e);
        }
        return document;
    }

    protected final CacheAccessByKey getCacheAccessByKey() {
        return this.cacheAccess;
    }

    protected void lotlParsing(DSSDocument document, LOTLSource source) {
        if (this.cacheAccess.isParsingRefreshNeeded()) {
            try {
                LOG.debug("Parsing LOTL with cache key '{}'...", (Object)source.getCacheKey().getKey());
                LOTLParsingTask parsingTask = new LOTLParsingTask(document, source);
                this.cacheAccess.update(parsingTask.get());
            }
            catch (Exception e) {
                LOG.error("Cannot parse the LOTL with the cache key '{}' : {}", (Object)source.getCacheKey().getKey(), (Object)e.getMessage());
                this.cacheAccess.parsingError(e);
            }
        }
    }

    protected void validation(DSSDocument document, CertificateSource certificateSource) {
        if (this.cacheAccess.isValidationRefreshNeeded()) {
            try {
                LOG.debug("Validating the TL/LOTL with cache key '{}'...", (Object)this.cacheAccess.getCacheKey().getKey());
                TLValidatorTask validationTask = new TLValidatorTask(document, certificateSource);
                this.cacheAccess.update(validationTask.get());
            }
            catch (Exception e) {
                LOG.error("Cannot validate the TL/LOTL with the cache key '{}' : {}", (Object)this.cacheAccess.getCacheKey().getKey(), (Object)e.getMessage());
                this.cacheAccess.validationError(e);
            }
        }
    }
}

