/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.RevocationDataLoadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLFirstRevocationDataLoadingStrategy
extends RevocationDataLoadingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CRLFirstRevocationDataLoadingStrategy.class);

    @Override
    public RevocationToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        RevocationToken<Revocation> result = this.checkCRL(certificateToken, issuerToken);
        if (result != null) {
            return result;
        }
        result = this.checkOCSP(certificateToken, issuerToken);
        if (result != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There is no response for {} neither from CRL nor from OCSP!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }
}

