/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.AlternateUrlsSourceAdapter;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.TokenIssuerSelector;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AIACertificateSource;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.RevocationDataLoadingStrategy;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.status.RevocationFreshnessStatus;
import eu.europa.esig.dss.validation.status.SignatureStatus;
import eu.europa.esig.dss.validation.status.TokenStatus;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<CertificateToken> processedCertificates = new HashSet<CertificateToken>();
    private final Set<RevocationToken<?>> processedRevocations = new HashSet();
    private final Set<TimestampToken> processedTimestamps = new HashSet<TimestampToken>();
    private CertificateVerifier certificateVerifier;
    private AIASource aiaSource;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private final Map<CertificateToken, Date> bestSignatureTimeCertChainDates = new HashMap<CertificateToken, Date>();
    private final Map<CertificateToken, Date> lastTimestampCertChainDates = new HashMap<CertificateToken, Date>();
    private final Map<String, List<POE>> poeTimes = new HashMap<String, List<POE>>();
    private final Map<Token, CertificateToken> tokenIssuerMap = new HashMap<Token, CertificateToken>();
    private final ListCertificateSource documentCertificateSource = new ListCertificateSource();
    private final ListRevocationSource<CRL> documentCRLSource = new ListRevocationSource();
    private final ListRevocationSource<OCSP> documentOCSPSource = new ListRevocationSource();
    private final ListCertificateSource aiaCertificateSources = new ListCertificateSource();
    private final ListCertificateSource revocationCertificateSources = new ListCertificateSource();
    private RevocationSource<OCSP> remoteOCSPSource;
    private RevocationSource<CRL> remoteCRLSource;
    private RevocationDataLoadingStrategy revocationDataLoadingStrategy;
    private ListCertificateSource trustedCertSources;
    private ListCertificateSource adjunctCertSources;
    private boolean checkRevocationForUntrustedChains;
    protected Date currentTime = new Date();

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null!");
        this.certificateVerifier = certificateVerifier;
        this.remoteCRLSource = certificateVerifier.getCrlSource();
        this.remoteOCSPSource = certificateVerifier.getOcspSource();
        this.aiaSource = certificateVerifier.getAIASource();
        this.revocationDataLoadingStrategy = certificateVerifier.getRevocationDataLoadingStrategy();
        this.adjunctCertSources = certificateVerifier.getAdjunctCertSources();
        this.trustedCertSources = certificateVerifier.getTrustedCertSources();
        this.checkRevocationForUntrustedChains = certificateVerifier.isCheckRevocationForUntrustedChains();
    }

    @Override
    public void addSignatureForVerification(AdvancedSignature signature) {
        this.addDocumentCertificateSource(signature.getCertificateSource());
        this.addDocumentCRLSource(signature.getCRLSource());
        this.addDocumentOCSPSource(signature.getOCSPSource());
        this.registerPOE(signature.getId(), this.currentTime);
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            this.addCertificateTokenForVerification(signingCertificate);
        } else {
            List<CertificateValidity> certificateValidities = signature.getCandidatesForSigningCertificate().getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    this.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
        }
        List<TimestampToken> timestamps = signature.getAllTimestamps();
        this.prepareTimestamps(timestamps);
        this.registerBestSignatureTime(signature);
        List<AdvancedSignature> counterSignatures = signature.getCounterSignatures();
        this.prepareCounterSignatures(counterSignatures);
    }

    @Override
    public void addDocumentCertificateSource(CertificateSource certificateSource) {
        this.addCertificateSource(this.documentCertificateSource, certificateSource);
    }

    @Override
    public void addDocumentCertificateSource(ListCertificateSource listCertificateSource) {
        for (CertificateSource certificateSource : listCertificateSource.getSources()) {
            this.addDocumentCertificateSource(certificateSource);
        }
    }

    private void addCertificateSource(ListCertificateSource listCertificateSource, CertificateSource certificateSourceToAdd) {
        listCertificateSource.add(certificateSourceToAdd);
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        for (CertificateToken certificateToken : certificateSourceToAdd.getCertificates()) {
            Set<CertificateToken> equivalentCertificates = allCertificateSources.getByPublicKey(certificateToken.getPublicKey());
            for (CertificateToken equivalentCertificate : equivalentCertificates) {
                if (certificateToken.getDSSIdAsString().equals(equivalentCertificate.getDSSIdAsString())) continue;
                this.addCertificateTokenForVerification(certificateToken);
            }
        }
    }

    @Override
    public void addDocumentCRLSource(OfflineRevocationSource<CRL> crlSource) {
        this.documentCRLSource.add(crlSource);
    }

    @Override
    public void addDocumentCRLSource(ListRevocationSource<CRL> crlSource) {
        this.documentCRLSource.addAll(crlSource);
    }

    @Override
    public void addDocumentOCSPSource(OfflineRevocationSource<OCSP> ocspSource) {
        this.documentOCSPSource.add(ocspSource);
    }

    @Override
    public void addDocumentOCSPSource(ListRevocationSource<OCSP> ocspSource) {
        this.documentOCSPSource.addAll(ocspSource);
    }

    private void prepareTimestamps(List<TimestampToken> timestampTokens) {
        for (TimestampToken timestampToken : timestampTokens) {
            this.addTimestampTokenForVerification(timestampToken);
        }
    }

    private void registerBestSignatureTime(AdvancedSignature signature) {
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            Date bestSignatureTime = this.getBestSignatureTime(signature);
            if (bestSignatureTime == null) {
                bestSignatureTime = this.currentTime;
            }
            List<CertificateToken> certificateChain = this.toCertificateTokenChain(this.getCertChain(signingCertificate));
            for (CertificateToken cert : certificateChain) {
                Date certBestSignatureTime = this.bestSignatureTimeCertChainDates.get(cert);
                if (certBestSignatureTime != null && !bestSignatureTime.after(certBestSignatureTime)) continue;
                this.bestSignatureTimeCertChainDates.put(cert, bestSignatureTime);
            }
        }
    }

    private Date getBestSignatureTime(AdvancedSignature signature) {
        Date bestSignatureTime = null;
        for (POE poe : this.poeTimes.get(signature.getId())) {
            if (bestSignatureTime != null && !bestSignatureTime.after(poe.getTime())) continue;
            bestSignatureTime = poe.getTime();
        }
        return bestSignatureTime;
    }

    private void prepareCounterSignatures(List<AdvancedSignature> counterSignatures) {
        for (AdvancedSignature counterSignature : counterSignatures) {
            this.addSignatureForVerification(counterSignature);
        }
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setCurrentTime(Date currentTime) {
        Objects.requireNonNull(currentTime);
        this.currentTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimestampToken getNotYetVerifiedTimestamp() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null || !(entry.getKey() instanceof TimestampToken)) continue;
                entry.setValue(true);
                return (TimestampToken)entry.getKey();
            }
            return null;
        }
    }

    private Map<CertificateToken, List<CertificateToken>> getOrderedCertificateChains() {
        CertificateReorderer order = new CertificateReorderer(this.processedCertificates);
        return order.getOrderedCertificateChains();
    }

    private List<Token> getCertChain(Token token) {
        LinkedList<Token> chain = new LinkedList<Token>();
        Token issuerCertificateToken = token;
        do {
            chain.add(issuerCertificateToken);
        } while ((issuerCertificateToken = this.getIssuer(issuerCertificateToken)) != null && !chain.contains(issuerCertificateToken));
        return chain;
    }

    private CertificateToken getIssuer(Token token) {
        CertificateToken issuerCertificateToken = this.getIssuerFromProcessedCertificates(token);
        if (issuerCertificateToken != null) {
            return issuerCertificateToken;
        }
        Set<CertificateToken> candidates = Collections.emptySet();
        if (token instanceof OCSPToken) {
            candidates = this.getIssuersFromSource(token, ((OCSPToken)token).getCertificateSource());
        }
        if (token instanceof TimestampToken) {
            candidates = this.getIssuersFromSource(token, ((TimestampToken)token).getCertificateSource());
        }
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = this.getIssuersFromSources(token, this.documentCertificateSource);
        }
        ListCertificateSource allCertificateSources = this.getAllCertificateSources();
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = this.getIssuersFromSources(token, allCertificateSources);
        }
        if (Utils.isCollectionEmpty(candidates)) {
            candidates = this.processedCertificates;
        }
        if ((issuerCertificateToken = new TokenIssuerSelector(token, candidates).getIssuer()) == null && token instanceof CertificateToken && this.aiaSource != null) {
            AIACertificateSource aiaCertificateSource = new AIACertificateSource((CertificateToken)token, this.aiaSource);
            issuerCertificateToken = aiaCertificateSource.getIssuerFromAIA();
            this.addCertificateSource(this.aiaCertificateSources, aiaCertificateSource);
        }
        if (issuerCertificateToken == null && token instanceof OCSPToken) {
            issuerCertificateToken = this.getOCSPIssuer((OCSPToken)token, allCertificateSources);
        }
        if (issuerCertificateToken == null && token instanceof TimestampToken) {
            issuerCertificateToken = this.getTSACertificate((TimestampToken)token, allCertificateSources);
        }
        if (issuerCertificateToken != null) {
            this.addCertificateTokenForVerification(issuerCertificateToken);
            this.tokenIssuerMap.put(token, issuerCertificateToken);
        }
        return issuerCertificateToken;
    }

    private CertificateToken getIssuerFromProcessedCertificates(Token token) {
        CertificateToken issuerCertificateToken = this.tokenIssuerMap.get(token);
        if (issuerCertificateToken != null && (token.getPublicKeyOfTheSigner() != null || token.isSignedBy(issuerCertificateToken))) {
            return issuerCertificateToken;
        }
        return null;
    }

    @Override
    public ListCertificateSource getAllCertificateSources() {
        ListCertificateSource allCertificateSources = new ListCertificateSource();
        allCertificateSources.addAll(this.documentCertificateSource);
        allCertificateSources.addAll(this.revocationCertificateSources);
        allCertificateSources.addAll(this.aiaCertificateSources);
        allCertificateSources.addAll(this.adjunctCertSources);
        allCertificateSources.addAll(this.trustedCertSources);
        return allCertificateSources;
    }

    @Override
    public ListCertificateSource getDocumentCertificateSource() {
        return this.documentCertificateSource;
    }

    @Override
    public ListRevocationSource<CRL> getDocumentCRLSource() {
        return this.documentCRLSource;
    }

    @Override
    public ListRevocationSource<OCSP> getDocumentOCSPSource() {
        return this.documentOCSPSource;
    }

    private Set<CertificateToken> getIssuersFromSources(Token token, ListCertificateSource allCertificateSources) {
        if (token.getPublicKeyOfTheSigner() != null) {
            return allCertificateSources.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return allCertificateSources.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private Set<CertificateToken> getIssuersFromSource(Token token, CertificateSource certificateSource) {
        if (token.getPublicKeyOfTheSigner() != null) {
            return certificateSource.getByPublicKey(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            return certificateSource.getBySubject(new X500PrincipalHelper(token.getIssuerX500Principal()));
        }
        return Collections.emptySet();
    }

    private CertificateToken getOCSPIssuer(OCSPToken token, ListCertificateSource allCertificateSources) {
        CertificateRef signingCertificateRef;
        ResponderId responderId;
        Set<CertificateRef> signingCertificateRefs = token.getCertificateSource().getAllCertificateRefs();
        if (Utils.collectionSize(signingCertificateRefs) == 1 && (responderId = (signingCertificateRef = signingCertificateRefs.iterator().next()).getResponderId()) != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            if (responderId.getSki() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySki(responderId.getSki()));
            }
            if (responderId.getX500Principal() != null) {
                issuerCandidates.addAll(allCertificateSources.getBySubject(new X500PrincipalHelper(responderId.getX500Principal())));
            }
            return new TokenIssuerSelector(token, issuerCandidates).getIssuer();
        }
        LOG.warn("Signing certificate is not found for an OCSPToken with id '{}'.", (Object)token.getDSSIdAsString());
        return null;
    }

    private CertificateToken getTSACertificate(TimestampToken timestamp, ListCertificateSource allCertificateSources) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = timestamp.getCandidatesForSigningCertificate();
        CertificateValidity theBestCandidate = candidatesForSigningCertificate.getTheBestCandidate();
        if (theBestCandidate != null) {
            HashSet<CertificateToken> issuerCandidates = new HashSet<CertificateToken>();
            CertificateToken timestampSigner = theBestCandidate.getCertificateToken();
            if (timestampSigner == null) {
                issuerCandidates.addAll(allCertificateSources.getByCertificateIdentifier(theBestCandidate.getSignerInfo()));
            } else {
                issuerCandidates.add(timestampSigner);
            }
            return new TokenIssuerSelector(timestamp, issuerCandidates).getIssuer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                this.registerPOE(token.getDSSIdAsString(), this.currentTime);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokenForVerification(RevocationToken<?> revocationToken) {
        if (this.addTokenForVerification(revocationToken)) {
            CertificateToken issuerCertificateToken;
            RevocationCertificateSource revocationCertificateSource = revocationToken.getCertificateSource();
            if (revocationCertificateSource != null) {
                this.addCertificateSource(this.revocationCertificateSources, revocationCertificateSource);
            }
            if ((issuerCertificateToken = revocationToken.getIssuerCertificateToken()) != null) {
                this.addCertificateTokenForVerification(issuerCertificateToken);
            }
            boolean added = this.processedRevocations.add(revocationToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("RevocationToken added to processedRevocations: {} ", (Object)revocationToken);
                } else {
                    LOG.trace("RevocationToken already present processedRevocations: {} ", (Object)revocationToken);
                }
            }
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification(certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedCertificates: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedCertificates: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            this.addDocumentCertificateSource(timestampToken.getCertificateSource());
            this.addDocumentCRLSource(timestampToken.getCRLSource());
            this.addDocumentOCSPSource(timestampToken.getOCSPSource());
            List<CertificateValidity> certificateValidities = timestampToken.getCandidatesForSigningCertificate().getCertificateValidityList();
            if (Utils.isCollectionNotEmpty(certificateValidities)) {
                for (CertificateValidity certificateValidity : certificateValidities) {
                    if (!certificateValidity.isValid() || certificateValidity.getCertificateToken() == null) continue;
                    this.addCertificateTokenForVerification(certificateValidity.getCertificateToken());
                }
            }
            this.registerTimestampUsageDate(timestampToken);
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedTimestamps: {} ", (Object)this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedTimestamps: {} ", (Object)this.processedTimestamps);
                }
            }
        }
    }

    private void registerTimestampUsageDate(TimestampToken timestampToken) {
        CertificateToken tsaCertificate = this.getTSACertificate(timestampToken, this.getAllCertificateSources());
        if (tsaCertificate == null) {
            LOG.warn("No Timestamp Certificate found. Chain is skipped.");
            return;
        }
        List<CertificateToken> tsaCertificateChain = this.toCertificateTokenChain(this.getCertChain(tsaCertificate));
        Date usageDate = timestampToken.getCreationDate();
        for (CertificateToken cert : tsaCertificateChain) {
            Date lastUsage = this.lastTimestampCertChainDates.get(cert);
            if (lastUsage != null && !lastUsage.before(usageDate)) continue;
            this.lastTimestampCertChainDates.put(cert, usageDate);
        }
        for (TimestampedReference timestampedReference : timestampToken.getTimestampedReferences()) {
            this.registerPOE(timestampedReference.getObjectId(), timestampToken);
        }
    }

    private void registerPOE(String tokenId, TimestampToken timestampToken) {
        List<POE> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<POE>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(new POE(timestampToken));
    }

    private void registerPOE(String tokenId, Date poeTime) {
        List<POE> poeTimeList = this.poeTimes.get(tokenId);
        if (Utils.isCollectionEmpty(poeTimeList)) {
            poeTimeList = new ArrayList<POE>();
            this.poeTimes.put(tokenId, poeTimeList);
        }
        poeTimeList.add(new POE(poeTime));
    }

    private List<CertificateToken> toCertificateTokenChain(List<Token> tokens) {
        LinkedList<CertificateToken> chain = new LinkedList<CertificateToken>();
        for (Token token : tokens) {
            if (!(token instanceof CertificateToken)) continue;
            chain.add((CertificateToken)token);
        }
        return chain;
    }

    @Override
    public void validate() {
        TimestampToken timestampToken = this.getNotYetVerifiedTimestamp();
        while (timestampToken != null) {
            this.getCertChain(timestampToken);
            timestampToken = this.getNotYetVerifiedTimestamp();
        }
        Token token = this.getNotYetVerifiedToken();
        while (token != null) {
            List<Token> certChain = this.getCertChain(token);
            if (token instanceof CertificateToken) {
                this.getRevocationData((CertificateToken)token, certChain);
            }
            token = this.getNotYetVerifiedToken();
        }
    }

    private Set<RevocationToken<?>> getRevocationData(CertificateToken certToken, List<Token> certChain) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for : {}", (Object)certToken.getDSSIdAsString());
        }
        if (this.isRevocationDataNotRequired(certToken)) {
            LOG.debug("Revocation data is not required for certificate : {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptySet();
        }
        CertificateToken issuerToken = this.getIssuer(certToken);
        if (issuerToken == null) {
            LOG.warn("Issuer not found for certificate {}", (Object)certToken.getDSSIdAsString());
            return Collections.emptySet();
        }
        HashSet revocations = new HashSet();
        List<RevocationToken<CRL>> crlTokens = this.documentCRLSource.getRevocationTokens(certToken, issuerToken);
        for (RevocationToken<CRL> revocationToken : crlTokens) {
            revocations.add(revocationToken);
            this.addRevocationTokenForVerification(revocationToken);
        }
        List<RevocationToken<OCSP>> ocspTokens = this.documentOCSPSource.getRevocationTokens(certToken, issuerToken);
        for (RevocationToken<OCSP> revocationToken : ocspTokens) {
            revocations.add(revocationToken);
            this.addRevocationTokenForVerification(revocationToken);
            this.addDocumentCertificateSource(revocationToken.getCertificateSource());
        }
        revocations.addAll(this.getRelatedRevocationTokens(certToken));
        if (Utils.isCollectionEmpty(revocations) || this.isRevocationDataRefreshNeeded(certToken, revocations)) {
            LOG.debug("The signature does not contain relative revocation data.");
            if (this.checkRevocationForUntrustedChains || this.containsTrustAnchor(certChain)) {
                LOG.trace("Revocation update is in progress for certificate : {}", (Object)certToken.getDSSIdAsString());
                CertificateToken certificateToken = (CertificateToken)this.getFirstTrustAnchor(certChain);
                RevocationToken<?> revocationToken = this.getRevocationToken(certToken, issuerToken, certificateToken);
                if (revocationToken != null && !revocations.contains(revocationToken)) {
                    LOG.debug("Obtained a new revocation data : {}, for certificate : {}", (Object)revocationToken.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
                    revocations.add(revocationToken);
                    this.addRevocationTokenForVerification(revocationToken);
                }
            } else {
                LOG.warn("External revocation check is skipped for untrusted certificate : {}", (Object)certToken.getDSSIdAsString());
            }
        }
        if (revocations.isEmpty()) {
            LOG.warn("No revocation found for the certificate {}", (Object)certToken.getDSSIdAsString());
        }
        return revocations;
    }

    private <T extends Token> boolean containsTrustAnchor(List<T> certChain) {
        return this.getFirstTrustAnchor(certChain) != null;
    }

    private <T extends Token> Token getFirstTrustAnchor(List<T> certChain) {
        for (Token token : certChain) {
            if (!this.isTrusted(token)) continue;
            return token;
        }
        return null;
    }

    private RevocationToken<?> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificate, CertificateToken trustAnchor) {
        RevocationSource<CRL> currentCRLSource;
        RevocationSource<OCSP> currentOCSPSource;
        ListCertificateSource currentCertSource = null;
        if (!this.trustedCertSources.isEmpty() && trustAnchor != null) {
            LOG.trace("Initializing a revocation verifier for a trusted chain...");
            currentOCSPSource = this.instantiateOCSPWithTrustServices(trustAnchor);
            currentCRLSource = this.instantiateCRLWithTrustServices(trustAnchor);
            currentCertSource = this.trustedCertSources;
        } else {
            LOG.trace("Initializing a revocation verifier for not trusted chain...");
            currentOCSPSource = this.remoteOCSPSource;
            currentCRLSource = this.remoteCRLSource;
        }
        this.revocationDataLoadingStrategy.setOcspSource(currentOCSPSource);
        this.revocationDataLoadingStrategy.setCrlSource(currentCRLSource);
        this.revocationDataLoadingStrategy.setTrustedCertificateSource(currentCertSource);
        return this.revocationDataLoadingStrategy.getRevocationToken(certificateToken, issuerCertificate);
    }

    private RevocationSource<OCSP> instantiateOCSPWithTrustServices(CertificateToken trustAnchor) {
        List<String> alternativeOCSPUrls = this.getAlternativeOCSPUrls(trustAnchor);
        if (Utils.isCollectionNotEmpty(alternativeOCSPUrls) && this.remoteOCSPSource instanceof RevocationSourceAlternateUrlsSupport) {
            return new AlternateUrlsSourceAdapter<OCSP>((RevocationSourceAlternateUrlsSupport)this.remoteOCSPSource, alternativeOCSPUrls);
        }
        return this.remoteOCSPSource;
    }

    private RevocationSource<CRL> instantiateCRLWithTrustServices(CertificateToken trustAnchor) {
        List<String> alternativeCRLUrls = this.getAlternativeCRLUrls(trustAnchor);
        if (Utils.isCollectionNotEmpty(alternativeCRLUrls) && this.remoteCRLSource instanceof RevocationSourceAlternateUrlsSupport) {
            return new AlternateUrlsSourceAdapter<CRL>((RevocationSourceAlternateUrlsSupport)this.remoteCRLSource, alternativeCRLUrls);
        }
        return this.remoteCRLSource;
    }

    private List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeOCSPUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof CommonTrustedCertificateSource)) continue;
            CommonTrustedCertificateSource trustedCertSource = (CommonTrustedCertificateSource)certificateSource;
            alternativeOCSPUrls.addAll(trustedCertSource.getAlternativeOCSPUrls(trustAnchor));
        }
        return alternativeOCSPUrls;
    }

    private List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        ArrayList<String> alternativeCRLUrls = new ArrayList<String>();
        for (CertificateSource certificateSource : this.trustedCertSources.getSources()) {
            if (!(certificateSource instanceof CommonTrustedCertificateSource)) continue;
            CommonTrustedCertificateSource trustedCertSource = (CommonTrustedCertificateSource)certificateSource;
            alternativeCRLUrls.addAll(trustedCertSource.getAlternativeCRLUrls(trustAnchor));
        }
        return alternativeCRLUrls;
    }

    @Override
    public boolean checkAllRequiredRevocationDataPresent() {
        TokenStatus status = new TokenStatus();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (List<CertificateToken> orderedCertChain : orderedCertificateChains.values()) {
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(orderedCertChain, null, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revocation data is missing for one or more certificate(s).");
            this.certificateVerifier.getAlertOnMissingRevocationData().alert(status);
        }
        return success;
    }

    private void checkRevocationForCertificateChainAgainstBestSignatureTime(List<CertificateToken> certificates, Date bestSignatureTime, TokenStatus status) {
        for (CertificateToken certificateToken : certificates) {
            Date lowestPOETime;
            if (this.isSelfSignedOrTrusted(certificateToken)) break;
            if (this.isOCSPNoCheckExtension(certificateToken)) continue;
            boolean found = false;
            Date earliestNextUpdate = null;
            List<RevocationToken<?>> relatedRevocationTokens = this.getRelatedRevocationTokens(certificateToken);
            for (RevocationToken<?> revocationToken : relatedRevocationTokens) {
                if (bestSignatureTime == null || bestSignatureTime.before(revocationToken.getThisUpdate())) {
                    found = true;
                    break;
                }
                if (revocationToken.getNextUpdate() == null || earliestNextUpdate != null && !earliestNextUpdate.after(revocationToken.getNextUpdate())) continue;
                earliestNextUpdate = revocationToken.getNextUpdate();
            }
            if (found) continue;
            if (!this.certificateVerifier.isCheckRevocationForUntrustedChains() && !this.containsTrustAnchor(certificates)) {
                status.addRelatedTokenAndErrorMessage(certificateToken, "Revocation data is skipped for untrusted certificate chain!");
            } else if (Utils.isCollectionEmpty(relatedRevocationTokens) || bestSignatureTime == null) {
                status.addRelatedTokenAndErrorMessage(certificateToken, "No revocation data found for certificate!");
            } else if (earliestNextUpdate != null) {
                status.addRelatedTokenAndErrorMessage(certificateToken, String.format("No revocation data found after the best signature time [%s]! The nextUpdate available after : [%s]", DSSUtils.formatDateToRFC(bestSignatureTime), DSSUtils.formatDateToRFC(earliestNextUpdate)));
            } else {
                status.addRelatedTokenAndErrorMessage(certificateToken, String.format("No revocation data found after the best signature time [%s]!", DSSUtils.formatDateToRFC(bestSignatureTime)));
            }
            if (!(status instanceof RevocationFreshnessStatus)) continue;
            if (Utils.isCollectionNotEmpty(relatedRevocationTokens) && earliestNextUpdate == null && (lowestPOETime = this.getLowestPOETime(certificateToken)) != null) {
                earliestNextUpdate = new Date(lowestPOETime.getTime() + 1000L);
            }
            if (earliestNextUpdate == null) continue;
            ((RevocationFreshnessStatus)status).addTokenAndRevocationNextUpdateTime(certificateToken, earliestNextUpdate);
        }
    }

    @Override
    public boolean checkAllPOECoveredByRevocationData() {
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            Date lastCertUsageDate = this.lastTimestampCertChainDates.get(firstChainCertificate);
            if (lastCertUsageDate == null) continue;
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), lastCertUsageDate, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revocation data is missing for one or more POE(s).");
            this.certificateVerifier.getAlertOnUncoveredPOE().alert(status);
        }
        return success;
    }

    @Override
    public boolean checkAllTimestampsValid() {
        TokenStatus status = new TokenStatus();
        for (TimestampToken timestampToken : this.processedTimestamps) {
            if (timestampToken.isSignatureIntact() && timestampToken.isMessageImprintDataFound().booleanValue() && timestampToken.isMessageImprintDataIntact().booleanValue()) continue;
            status.addRelatedTokenAndErrorMessage(timestampToken, "Signature is not intact!");
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Broken timestamp(s) detected.");
            this.certificateVerifier.getAlertOnInvalidTimestamp().alert(status);
        }
        return success;
    }

    @Override
    public boolean checkAllCertificatesValid() {
        TokenStatus status = new TokenStatus();
        for (CertificateToken certificateToken : this.processedCertificates) {
            List<RevocationToken<?>> relatedRevocationTokens;
            if (this.isRevocationDataNotRequired(certificateToken) || !Utils.isCollectionNotEmpty(relatedRevocationTokens = this.getRelatedRevocationTokens(certificateToken))) continue;
            Date lowestPOETime = this.getLowestPOETime(certificateToken);
            for (RevocationToken<?> revocationToken : relatedRevocationTokens) {
                if ((!revocationToken.getStatus().isRevoked() || lowestPOETime == null || lowestPOETime.before(revocationToken.getRevocationDate())) && revocationToken.getStatus().isKnown()) continue;
                status.addRelatedTokenAndErrorMessage(certificateToken, "Certificate is revoked/suspended!");
            }
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Revoked/Suspended certificate(s) detected.");
            this.certificateVerifier.getAlertOnRevokedCertificate().alert(status);
        }
        return success;
    }

    private boolean isRevocationDataNotRequired(CertificateToken certToken) {
        return this.isSelfSignedOrTrusted(certToken) || this.isOCSPNoCheckExtension(certToken);
    }

    private boolean isSelfSignedOrTrusted(CertificateToken certToken) {
        return certToken.isSelfSigned() || this.isTrusted(certToken);
    }

    private boolean isOCSPNoCheckExtension(CertificateToken certToken) {
        return DSSASN1Utils.hasIdPkixOcspNoCheckExtension(certToken);
    }

    private List<RevocationToken<?>> getRelatedRevocationTokens(CertificateToken certificateToken) {
        ArrayList result = new ArrayList();
        for (RevocationToken<?> revocationToken : this.processedRevocations) {
            if (!Utils.areStringsEqual(certificateToken.getDSSIdAsString(), revocationToken.getRelatedCertificateId())) continue;
            result.add(revocationToken);
        }
        return result;
    }

    private boolean isRevocationDataRefreshNeeded(CertificateToken certToken, Collection<RevocationToken<?>> revocations) {
        Date refreshNeededAfterTime = this.bestSignatureTimeCertChainDates.get(certToken);
        Date lastTimestampUsageTime = this.lastTimestampCertChainDates.get(certToken);
        if (lastTimestampUsageTime != null && (refreshNeededAfterTime == null || lastTimestampUsageTime.after(refreshNeededAfterTime))) {
            refreshNeededAfterTime = lastTimestampUsageTime;
        }
        if (refreshNeededAfterTime == null) {
            refreshNeededAfterTime = this.getLowestPOETime(certToken);
        }
        boolean freshRevocationDataFound = false;
        for (RevocationToken<?> revocationToken : revocations) {
            if (refreshNeededAfterTime == null || !refreshNeededAfterTime.before(revocationToken.getThisUpdate()) || RevocationReason.CERTIFICATE_HOLD == revocationToken.getReason() || !this.isConsistent(revocationToken, certToken)) continue;
            freshRevocationDataFound = true;
            break;
        }
        if (!freshRevocationDataFound) {
            LOG.debug("Revocation data refresh is needed");
            return true;
        }
        return false;
    }

    private Date getLowestPOETime(Token token) {
        Date lowestPOE = null;
        List<POE> poeList = this.poeTimes.get(token.getDSSIdAsString());
        if (Utils.isCollectionEmpty(poeList)) {
            throw new IllegalStateException("POE shall be defined before accessing the 'poeTimes' list!");
        }
        for (POE poe : poeList) {
            Date poeTime = poe.getTime();
            if (lowestPOE != null && !poeTime.before(lowestPOE)) continue;
            lowestPOE = poeTime;
        }
        return lowestPOE;
    }

    private boolean isConsistent(RevocationToken<?> revocation, CertificateToken certToken) {
        List<CertificateToken> certificateTokenChain = this.toCertificateTokenChain(this.getCertChain(revocation));
        if (Utils.isCollectionEmpty(certificateTokenChain)) {
            LOG.debug("The revocation {} is not consistent! Issuer CertificateToken is not found.", (Object)revocation.getDSSIdAsString());
            return false;
        }
        if (!this.revocationDataHasInformationAboutCertificate(revocation, certToken)) {
            LOG.debug("The revocation '{}' has been produced before the start of the validity of the certificate '{}'!", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
            return false;
        }
        if (RevocationType.OCSP.equals((Object)revocation.getRevocationType()) && !DSSRevocationUtils.checkIssuerValidAtRevocationProductionTime(revocation)) {
            LOG.debug("The revocation '{}' is not consistent! The revocation has been produced outside the issuer certificate's validity range!", (Object)revocation.getDSSIdAsString());
            return false;
        }
        if (RevocationType.CRL.equals((Object)revocation.getRevocationType()) && !this.isInCertificateValidityRange(revocation, certToken)) {
            LOG.debug("The revocation '{}' was not issued during the validity period of the certificate! Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
            return false;
        }
        if (revocation.getNextUpdate() != null && !this.hasPOEAfterProductionAndBeforeNextUpdate(revocation)) {
            LOG.debug("There is no POE for the revocation '{}' after its production time and before the nextUpdate! Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
            return false;
        }
        CertificateToken revocationIssuer = certificateTokenChain.iterator().next();
        if (!this.isTrusted(revocationIssuer) && !this.hasPOEInTheValidityRange(revocationIssuer)) {
            LOG.debug("There is no POE for the revocation issuer '{}' for revocation '{}' within its validity range! Certificate: {}", revocationIssuer.getDSSIdAsString(), revocation.getDSSIdAsString(), certToken.getDSSIdAsString());
            return false;
        }
        LOG.debug("The revocation '{}' is consistent. Certificate: {}", (Object)revocation.getDSSIdAsString(), (Object)certToken.getDSSIdAsString());
        return true;
    }

    private boolean revocationDataHasInformationAboutCertificate(RevocationToken<?> revocationToken, CertificateToken certificateToken) {
        return certificateToken.getNotBefore().compareTo(revocationToken.getThisUpdate()) <= 0;
    }

    private boolean isInCertificateValidityRange(RevocationToken<?> revocationToken, CertificateToken certificateToken) {
        Date thisUpdate = revocationToken.getThisUpdate();
        Date nextUpdate = revocationToken.getNextUpdate();
        Date notAfter = certificateToken.getNotAfter();
        Date notBefore = certificateToken.getNotBefore();
        return thisUpdate.compareTo(notAfter) <= 0 && nextUpdate != null && nextUpdate.compareTo(notBefore) >= 0;
    }

    private boolean hasPOEAfterProductionAndBeforeNextUpdate(RevocationToken<?> revocation) {
        List<POE> poeTimeList = this.poeTimes.get(revocation.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!this.isConsistentOnTime(revocation, poeTime.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPOEInTheValidityRange(CertificateToken certificateToken) {
        List<POE> poeTimeList = this.poeTimes.get(certificateToken.getDSSIdAsString());
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!certificateToken.isValidOn(poeTime.getTime())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isConsistentOnTime(RevocationToken<?> revocationToken, Date date) {
        Date productionDate = revocationToken.getProductionDate();
        Date nextUpdate = revocationToken.getNextUpdate();
        return date.compareTo(productionDate) >= 0 && date.compareTo(nextUpdate) <= 0;
    }

    @Override
    public boolean checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(AdvancedSignature signature) {
        RevocationFreshnessStatus status = new RevocationFreshnessStatus();
        CertificateToken signingCertificateToken = signature.getSigningCertificateToken();
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            CertificateToken firstChainCertificate = entry.getKey();
            if (!firstChainCertificate.equals(signingCertificateToken)) continue;
            Date bestSignatureTime = this.getEarliestTimestampTime();
            this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), bestSignatureTime, status);
        }
        boolean success = status.isEmpty();
        if (!success) {
            status.setMessage("Fresh revocation data is missing for one or more certificate(s).");
            this.certificateVerifier.getAlertOnNoRevocationAfterBestSignatureTime().alert(status);
        }
        return success;
    }

    private Date getEarliestTimestampTime() {
        Date earliestDate = null;
        for (TimestampToken timestamp : this.getProcessedTimestamps()) {
            if (!timestamp.getTimeStampType().coversSignature()) continue;
            Date timestampTime = timestamp.getCreationDate();
            if (earliestDate != null && !timestampTime.before(earliestDate)) continue;
            earliestDate = timestampTime;
        }
        return earliestDate;
    }

    @Override
    public boolean checkSignatureNotExpired(AdvancedSignature signature) {
        SignatureStatus status = new SignatureStatus();
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        if (signingCertificate != null) {
            boolean signatureNotExpired = this.verifyCertificateTokenHasPOERecursively(signingCertificate, this.poeTimes.get(signature.getId()));
            if (!signatureNotExpired) {
                status.addRelatedTokenAndErrorMessage(signature, String.format("The signing certificate has expired and there is no POE during its validity range : [%s - %s]!", DSSUtils.formatDateToRFC(signingCertificate.getNotBefore()), DSSUtils.formatDateToRFC(signingCertificate.getNotAfter())));
                status.setMessage("Expired signature found.");
                this.certificateVerifier.getAlertOnExpiredSignature().alert(status);
            }
            return signatureNotExpired;
        }
        return true;
    }

    private boolean verifyCertificateTokenHasPOERecursively(CertificateToken certificateToken, List<POE> poeTimeList) {
        if (Utils.isCollectionNotEmpty(poeTimeList)) {
            for (POE poeTime : poeTimeList) {
                if (!certificateToken.isValidOn(poeTime.getTime())) continue;
                TimestampToken timestampToken = poeTime.getTimestampToken();
                if (timestampToken != null) {
                    CertificateToken issuerCertificateToken = this.getIssuer(timestampToken);
                    if (issuerCertificateToken == null || !this.verifyCertificateTokenHasPOERecursively(issuerCertificateToken, this.poeTimes.get(timestampToken.getDSSIdAsString()))) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Set<RevocationToken> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    private <T extends Token> boolean isTrusted(T token) {
        return token instanceof CertificateToken && this.trustedCertSources.isTrusted((CertificateToken)token);
    }

    @Override
    public ValidationData getValidationData(AdvancedSignature signature) {
        return this.getValidationData(signature.getSigningCertificateToken());
    }

    @Override
    public ValidationData getValidationData(TimestampToken timestampToken) {
        return this.getValidationData(this.getIssuer(timestampToken));
    }

    private ValidationData getValidationData(CertificateToken certificateToken) {
        ValidationData validationData = new ValidationData();
        if (certificateToken != null) {
            this.populateValidationDataRecursively(certificateToken, validationData);
        }
        return validationData;
    }

    private void populateValidationDataRecursively(Token token, ValidationData validationData) {
        boolean added = validationData.addToken(token);
        if (added) {
            CertificateToken issuerToken;
            if (token instanceof CertificateToken) {
                List<RevocationToken<?>> revocationTokens = this.getRelatedRevocationTokens((CertificateToken)token);
                for (RevocationToken<?> revocationToken : revocationTokens) {
                    this.populateValidationDataRecursively(revocationToken, validationData);
                }
            }
            if ((issuerToken = this.getIssuer(token)) != null) {
                this.populateValidationDataRecursively(issuerToken, validationData);
            }
        }
    }

    private static class POE {
        private final Date time;
        private TimestampToken timestampToken;

        public POE(Date time) {
            this.time = time;
        }

        public POE(TimestampToken timestampToken) {
            this.timestampToken = timestampToken;
            this.time = timestampToken.getCreationDate();
        }

        public Date getTime() {
            return this.time;
        }

        public TimestampToken getTimestampToken() {
            return this.timestampToken;
        }
    }
}

