/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;

public class DigestAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final DigestAlgorithm digestAlgo;

    protected DigestAlgorithmReliableCheck(I18nProvider i18nProvider, DigestAlgorithm digestAlgo, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.digestAlgo = digestAlgo;
    }

    @Override
    protected boolean process() {
        return this.constraintWrapper.isDigestAlgorithmReliable(this.digestAlgo);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_DAA, this.getName(this.digestAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_DAA_ANS, new Object[]{this.getName(this.digestAlgo), this.position});
    }
}

