/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final MessageTag position;
    protected final XmlCC ccResult;
    private final XmlMessage checkerResultMessage;

    protected AbstractCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, MessageTag position, XmlCC ccResult, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.position = position;
        this.ccResult = ccResult;
        this.checkerResultMessage = AbstractCryptographicCheckerResultCheck.extractXmlMessage(ccResult, constraint);
    }

    private static XmlMessage extractXmlMessage(XmlCC ccResult, LevelConstraint constraint) {
        XmlConclusion conclusion = ccResult.getConclusion();
        if (conclusion != null && constraint != null && constraint.getLevel() != null) {
            ArrayList<XmlMessage> messages = new ArrayList<XmlMessage>();
            switch (constraint.getLevel()) {
                case INFORM: {
                    messages.addAll(conclusion.getInfos());
                    messages.addAll(conclusion.getWarnings());
                    messages.addAll(conclusion.getErrors());
                    break;
                }
                case WARN: {
                    messages.addAll(conclusion.getWarnings());
                    messages.addAll(conclusion.getErrors());
                    break;
                }
                case FAIL: {
                    messages.addAll(conclusion.getErrors());
                    break;
                }
            }
            if (Utils.isCollectionNotEmpty(messages)) {
                return (XmlMessage)messages.iterator().next();
            }
        }
        return null;
    }

    @Override
    protected boolean process() {
        return this.isValid(this.ccResult) && this.allConstraintsValid(this.ccResult);
    }

    private boolean allConstraintsValid(XmlConstraintsConclusion result) {
        List<XmlConstraint> constraints = result.getConstraint();
        if (Utils.isCollectionNotEmpty(constraints)) {
            for (XmlConstraint constraint : constraints) {
                if (XmlStatus.OK.equals((Object)constraint.getStatus()) || XmlStatus.IGNORED.equals((Object)constraint.getStatus())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ACCM, new Object[]{this.position});
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.checkerResultMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ccResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ccResult.getConclusion().getSubIndication();
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        return this.ccResult.getConclusion().getErrors();
    }

    protected String getErrorMessage() {
        return this.checkerResultMessage != null ? this.checkerResultMessage.getValue() : "";
    }
}

