/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;
import java.util.stream.Collectors;

public class SigningCertificateReferencesValidityCheck
extends ChainItem<XmlSAV> {
    private final TokenProxy token;

    public SigningCertificateReferencesValidityCheck(I18nProvider i18nProvider, XmlSAV result, TokenProxy token, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.token = token;
    }

    @Override
    protected boolean process() {
        FoundCertificatesProxy foundCertificates = this.token.foundCertificates();
        List<CertificateRefWrapper> orphanSigningCertificateRefs = foundCertificates.getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        if (Utils.isCollectionNotEmpty(orphanSigningCertificateRefs)) {
            return false;
        }
        List<RelatedCertificateWrapper> relatedSigningCertificates = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        List certificateChainIds = this.token.getCertificateChain().stream().map(CertificateWrapper::getId).collect(Collectors.toList());
        for (RelatedCertificateWrapper signingCertificate : relatedSigningCertificates) {
            if (certificateChainIds.contains(signingCertificate.getId())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_DSCACRCC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_DSCACRCC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

