/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfbs.AbstractBasicValidationProcess;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BasicSignatureValidationProcess
extends AbstractBasicValidationProcess<XmlValidationProcessBasicSignature> {
    private final List<XmlTimestamp> xmlTimestamps;

    public BasicSignatureValidationProcess(I18nProvider i18nProvider, DiagnosticData diagnosticData, SignatureWrapper signatureWrapper, List<XmlTimestamp> xmlTimestamps, Map<String, XmlBasicBuildingBlocks> bbbs) {
        super(i18nProvider, new XmlValidationProcessBasicSignature(), diagnosticData, signatureWrapper, bbbs);
        this.xmlTimestamps = xmlTimestamps;
        ((XmlValidationProcessBasicSignature)this.result).setProofOfExistence(this.getCurrentTime(diagnosticData));
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPBS;
    }

    private XmlProofOfExistence getCurrentTime(DiagnosticData diagnosticData) {
        XmlProofOfExistence proofOfExistence = new XmlProofOfExistence();
        proofOfExistence.setTime(diagnosticData.getValidationDate());
        return proofOfExistence;
    }

    @Override
    protected List<TimestampWrapper> getContentTimestamps() {
        SignatureWrapper signature = this.diagnosticData.getSignatureById(this.token.getId());
        if (signature != null) {
            return signature.getContentTimestamps();
        }
        return Collections.emptyList();
    }

    @Override
    protected XmlValidationProcessTimestamp getTimestampValidation(String timestampId) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!Utils.areStringsEqual(timestampId, xmlTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessTimestamp();
        }
        return null;
    }
}

