/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.validation.DataIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class SignatureScope
implements IdentifierBasedObject,
Serializable {
    private static final long serialVersionUID = -5579782848203348145L;
    private final String name;
    private final Digest dataDigest;
    private DataIdentifier dssId;
    private List<SignatureScope> children;

    protected SignatureScope(String name, Digest digest) {
        this.name = name;
        this.dataDigest = digest;
    }

    public String getName() {
        return this.name;
    }

    public Digest getDigest() {
        return this.dataDigest;
    }

    public abstract String getDescription();

    public List<String> getTransformations() {
        return null;
    }

    public abstract SignatureScopeType getType();

    public List<SignatureScope> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<SignatureScope>();
        }
        return this.children;
    }

    public void addChildSignatureScope(SignatureScope signatureScope) {
        this.getChildren().add(signatureScope);
    }

    @Override
    public DataIdentifier getDSSId() {
        if (this.dssId != null) {
            return this.dssId;
        }
        String uniqueString = this.name + this.dataDigest.toString();
        this.dssId = new DataIdentifier(uniqueString.getBytes());
        return this.dssId;
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SignatureScope)) {
            return false;
        }
        SignatureScope s2 = (SignatureScope)obj;
        return this.getDSSId().equals(s2.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }
}

