/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.xades.reference.AbstractTransform;
import java.io.IOException;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ComplexTransform
extends AbstractTransform {
    private static final long serialVersionUID = -2344414065328072642L;
    private Transform transformObject;

    protected ComplexTransform(DSSNamespace xmlDSigNamespace, String algorithm) {
        super(xmlDSigNamespace, algorithm);
    }

    private void buildTransformObject() {
        try {
            Document document = DomUtils.buildDOM();
            Element transformsDom = DomUtils.createElementNS(document, this.namespace, XMLDSigElement.TRANSFORMS);
            document.appendChild(transformsDom);
            this.createTransform(document, transformsDom);
            NodeList childNodes = transformsDom.getFirstChild().getChildNodes();
            Transform transform = new Transform(document, this.algorithm, childNodes);
            for (Map.Entry<String, String> namespace : DomUtils.getCurrentNamespaces().entrySet()) {
                transform.setXPathNamespaceContext(namespace.getKey(), namespace.getValue());
            }
            this.transformObject = transform;
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Cannot initialize a transform [%s]", this.algorithm), e);
        }
    }

    @Override
    public byte[] getBytesAfterTransformation(Node node) {
        if (this.transformObject == null) {
            this.buildTransformObject();
        }
        try {
            XMLSignatureInput xmlSignatureInput = this.getXMLSignatureInput(node);
            XMLSignatureInput xmlSignatureInputOut = this.transformObject.performTransform(xmlSignatureInput, true);
            return xmlSignatureInputOut.getBytes();
        }
        catch (IOException | XMLSecurityException e) {
            throw new DSSException(String.format("Cannot process transformation [%s] on the given DOM object. Reason : [%s]", this.algorithm, e.getMessage()), e);
        }
    }

    protected XMLSignatureInput getXMLSignatureInput(Node node) {
        return new XMLSignatureInput(node);
    }
}

