/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class XmlPolicyWithTransforms
extends Policy {
    private static final long serialVersionUID = 8177559439441560945L;
    private List<DSSTransform> transforms;

    public List<DSSTransform> getTransforms() {
        return this.transforms;
    }

    public void setTransforms(List<DSSTransform> transforms) {
        this.transforms = transforms;
    }

    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        return !Utils.isCollectionNotEmpty(this.transforms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.transforms == null ? 0 : this.transforms.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlPolicyWithTransforms other = (XmlPolicyWithTransforms)obj;
        return Objects.equals(this.transforms, other.transforms);
    }

    @Override
    public String toString() {
        return "XmlPolicyWithTransforms {id='" + this.getId() + "', qualifier=" + (Object)((Object)this.getQualifier()) + ", description='" + this.getDescription() + "', documentationReferences=" + Arrays.toString(this.getDocumentationReferences()) + ", digestAlgorithm=" + this.getDigestAlgorithm() + ", digestValue=" + Arrays.toString(this.getDigestValue()) + ", spUri='" + this.getSpuri() + "', userNotice=" + this.getUserNotice() + ", spDocSpecification='" + this.getSpDocSpecification() + "', transforms=" + this.transforms + "}";
    }
}

