/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.scope.EncapsulatedTimestampScopeFinder;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.SAMLAssertionNamespace;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.policy.XMLSignaturePolicyValidator;
import eu.europa.esig.dss.xades.validation.scope.XAdESSignatureScopeFinder;
import eu.europa.esig.dss.xades.validation.scope.XAdESTimestampScopeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentValidator
extends SignedDocumentValidator {
    protected List<XAdESPaths> xadesPathsHolders;
    protected Document rootElement;
    private boolean disableXSWProtection = false;
    private List<AdvancedSignature> signatures;

    XMLDocumentValidator() {
    }

    public XMLDocumentValidator(DSSDocument dssDocument) {
        super(new XAdESSignatureScopeFinder());
        Objects.requireNonNull(dssDocument, "Document to be validated cannot be null!");
        this.document = dssDocument;
        this.rootElement = this.toDomDocument(dssDocument);
        this.xadesPathsHolders = new ArrayList<XAdESPaths>();
        this.xadesPathsHolders.add(new XAdES111Paths());
        this.xadesPathsHolders.add(new XAdES122Paths());
        this.xadesPathsHolders.add(new XAdES132Paths());
    }

    private Document toDomDocument(DSSDocument document) {
        try {
            return DomUtils.buildDOM(document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("An XML file is expected : %s", e.getMessage()), e);
        }
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return DomUtils.startsWithXmlPreamble(dssDocument);
    }

    public void setDisableXSWProtection(boolean disableXSWProtection) {
        this.disableXSWProtection = disableXSWProtection;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures != null) {
            return this.signatures;
        }
        this.signatures = new ArrayList<AdvancedSignature>();
        NodeList signatureNodeList = DSSXMLUtils.getAllSignaturesExceptCounterSignatures(this.rootElement);
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            Node parent = signatureEl.getParentNode();
            String nodeName = parent.getNodeName();
            String ns = parent.getNamespaceURI();
            if ("saml2:Assertion".equals(nodeName) && SAMLAssertionNamespace.NS.isSameUri(ns)) continue;
            XAdESSignature xadesSignature = new XAdESSignature(signatureEl, this.xadesPathsHolders);
            xadesSignature.setSignatureFilename(this.document.getName());
            xadesSignature.setDetachedContents(this.detachedContents);
            xadesSignature.setContainerContents(this.containerContents);
            xadesSignature.setSigningCertificateSource(this.signingCertificateSource);
            xadesSignature.setDisableXSWProtection(this.disableXSWProtection);
            xadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
            this.signatures.add(xadesSignature);
        }
        return this.signatures;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature signature = (XAdESSignature)advancedSignature;
        return XAdESSignatureUtils.getSignerDocuments(signature);
    }

    public List<XAdESPaths> getXAdESPathsHolder() {
        return this.xadesPathsHolders;
    }

    public void addXAdESPathsHolder(XAdESPaths xadesPathsHolder) {
        this.xadesPathsHolders.add(xadesPathsHolder);
    }

    public void clearQueryHolders() {
        this.xadesPathsHolders.clear();
    }

    public Document getRootElement() {
        return this.rootElement;
    }

    @Override
    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        DefaultSignaturePolicyValidatorLoader signaturePolicyValidatorLoader = new DefaultSignaturePolicyValidatorLoader();
        signaturePolicyValidatorLoader.setDefaultSignaturePolicyValidator(new XMLSignaturePolicyValidator());
        return signaturePolicyValidatorLoader;
    }

    @Override
    protected EncapsulatedTimestampScopeFinder getTimestampScopeFinder() {
        return new XAdESTimestampScopeFinder();
    }

    static {
        XAdESNamespaces.registerNamespaces();
        DomUtils.registerNamespace(SAMLAssertionNamespace.NS);
    }
}

