/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.CounterSignatureScope;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestEntrySignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.scope.XPointerSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlElementSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlFullSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlRootSignatureScope;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder
implements SignatureScopeFinder<XAdESSignature> {
    @Override
    public List<SignatureScope> findSignatureScope(XAdESSignature xadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List<ReferenceValidation> referenceValidations = xadesSignature.getReferenceValidations();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (DigestMatcherType.SIGNED_PROPERTIES.equals((Object)referenceValidation.getType()) || DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || DigestMatcherType.SIGNATURE_PROPERTIES.equals((Object)referenceValidation.getType()) || !(referenceValidation instanceof XAdESReferenceValidation)) continue;
            XAdESReferenceValidation xadesReferenceValidation = (XAdESReferenceValidation)referenceValidation;
            String uri = xadesReferenceValidation.getUri();
            String xmlIdOfSignedElement = DomUtils.getId(uri);
            List<String> transformations = xadesReferenceValidation.getTransformationNames();
            if (xadesReferenceValidation.isFound() && DigestMatcherType.XPOINTER.equals((Object)xadesReferenceValidation.getType())) {
                result.add(new XPointerSignatureScope(uri, transformations, this.getDigest(xadesReferenceValidation.getOriginalContentBytes())));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.OBJECT.equals((Object)xadesReferenceValidation.getType())) {
                Node objectById = xadesSignature.getObjectById(uri);
                if (objectById == null || !objectById.hasChildNodes()) continue;
                Node referencedObject = objectById.getFirstChild();
                result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations, this.getDigest(DSSXMLUtils.getNodeBytes(referencedObject))));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.MANIFEST.equals((Object)xadesReferenceValidation.getType())) {
                ManifestSignatureScope manifestSignatureScope = new ManifestSignatureScope(xadesReferenceValidation.getName(), xadesReferenceValidation.getDigest(), xadesReferenceValidation.getTransformationNames());
                result.add(manifestSignatureScope);
                for (ReferenceValidation manifestEntry : xadesReferenceValidation.getDependentValidations()) {
                    if (manifestEntry.getName() == null || !manifestEntry.isFound()) continue;
                    SignatureScope detachedSignatureScopeResult = this.getFromDetachedContent(xadesSignature, transformations, manifestEntry.getName());
                    if (detachedSignatureScopeResult != null) {
                        manifestSignatureScope.addChildSignatureScope(detachedSignatureScopeResult);
                        continue;
                    }
                    if (manifestEntry.getDigest() == null) continue;
                    manifestSignatureScope.addChildSignatureScope(new ManifestEntrySignatureScope(manifestEntry.getName(), manifestEntry.getDigest(), xadesReferenceValidation.getName(), manifestEntry.getTransformationNames()));
                }
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.COUNTER_SIGNATURE.equals((Object)xadesReferenceValidation.getType()) && xadesSignature.getMasterSignature() != null) {
                result.add(new CounterSignatureScope(xadesSignature.getMasterSignature().getId(), this.getDigest(xadesReferenceValidation.getOriginalContentBytes())));
                continue;
            }
            if (xadesReferenceValidation.isFound() && "".equals(uri)) {
                byte[] originalContentBytes = xadesReferenceValidation.getOriginalContentBytes();
                if (originalContentBytes == null) continue;
                result.add(new XmlRootSignatureScope(transformations, this.getDigest(originalContentBytes)));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DomUtils.isElementReference(uri)) {
                Element signedElement = DomUtils.getElementById(xadesSignature.getSignatureElement().getOwnerDocument(), DomUtils.getId(uri));
                if (signedElement == null) continue;
                if (this.isEverythingCovered(xadesSignature, xmlIdOfSignedElement)) {
                    result.add(new XmlRootSignatureScope(transformations, this.getDigest(DSSXMLUtils.getNodeBytes(signedElement))));
                    continue;
                }
                result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations, this.getDigest(DSSXMLUtils.getNodeBytes(signedElement))));
                continue;
            }
            if (xadesReferenceValidation.isIntact() && Utils.isCollectionNotEmpty(xadesSignature.getDetachedContents())) {
                result.add(this.getFromDetachedContent(xadesSignature, transformations, uri));
                continue;
            }
            if (!Utils.isCollectionEmpty(transformations)) continue;
            result.add(new FullSignatureScope(uri, xadesReferenceValidation.getDigest()));
        }
        return result;
    }

    private SignatureScope getFromDetachedContent(XAdESSignature xadesSignature, List<String> transformations, String uri) {
        List<DSSDocument> detachedContents = xadesSignature.getDetachedContents();
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                String fileName;
                String decodedUrl;
                String string = decodedUrl = uri != null ? DSSUtils.decodeURI(uri) : uri;
                if (detachedDocument.getName() != null && (uri != null || detachedContents.size() != 1) && (uri == null || !uri.equals(detachedDocument.getName()) && !decodedUrl.equals(detachedDocument.getName()))) continue;
                String string2 = fileName = detachedDocument.getName() != null ? detachedDocument.getName() : decodedUrl;
                if (detachedDocument instanceof DigestDocument) {
                    DigestDocument digestDocument = (DigestDocument)detachedDocument;
                    return new DigestSignatureScope(fileName, digestDocument.getExistingDigest());
                }
                if (Utils.isCollectionNotEmpty(transformations)) {
                    return new XmlFullSignatureScope(fileName, transformations, this.getDigest(detachedDocument));
                }
                if (this.isASiCSArchive(xadesSignature, detachedDocument)) {
                    ContainerSignatureScope containerSignatureScope = new ContainerSignatureScope(decodedUrl, this.getDigest(detachedDocument));
                    for (DSSDocument archivedDocument : xadesSignature.getContainerContents()) {
                        containerSignatureScope.addChildSignatureScope(new ContainerContentSignatureScope(DSSUtils.decodeURI(archivedDocument.getName()), this.getDigest(archivedDocument)));
                    }
                    return containerSignatureScope;
                }
                return new FullSignatureScope(fileName, this.getDigest(detachedDocument));
            }
        }
        return null;
    }

    private boolean isEverythingCovered(XAdESSignature signature, String coveredObjectId) {
        Element parent = signature.getSignatureElement().getOwnerDocument().getDocumentElement();
        return parent != null && this.isRelatedToUri(parent, coveredObjectId);
    }

    private boolean isRelatedToUri(Node currentNode, String id) {
        String idValue = DSSXMLUtils.getIDIdentifier(currentNode);
        if (idValue == null) {
            return Utils.isStringBlank(id);
        }
        return id.equals(idValue) || id.equals("");
    }
}

