/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.timestamp;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampDataBuilder
implements TimestampDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampDataBuilder.class);
    private static final String MESSAGE_IMPRINT_ERROR = "Unable to compute message-imprint for TimestampToken with Id '{}'. Reason : {}";
    private final List<Reference> references;
    private final Element signature;
    private final XAdESPaths xadesPaths;

    public XAdESTimestampDataBuilder(Element signature, List<Reference> references, XAdESPaths xadesPaths) {
        this.signature = signature;
        this.references = references;
        this.xadesPaths = xadesPaths;
    }

    @Override
    public DSSDocument getContentTimestampData(TimestampToken timestampToken) {
        TimestampType timeStampType = timestampToken.getTimeStampType();
        if (!timeStampType.isContentTimestamp()) {
            return null;
        }
        if (this.references.isEmpty()) {
            throw new IllegalStateException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        switch (timeStampType) {
            case ALL_DATA_OBJECTS_TIMESTAMP: {
                return this.getAllDataObjectsTimestampData(timestampToken);
            }
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                return this.getIndividualDataObjectsTimestampData(timestampToken);
            }
        }
        throw new UnsupportedOperationException(String.format("The content timestamp of type '%s' is not supported!", new Object[]{timeStampType}));
    }

    protected DSSDocument getAllDataObjectsTimestampData(TimestampToken timestampToken) {
        InMemoryDocument inMemoryDocument;
        String canonicalizationMethod = timestampToken.getCanonicalizationMethod();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            for (Reference reference : this.references) {
                if (DSSXMLUtils.isSignedProperties(reference, this.xadesPaths)) continue;
                byte[] referenceBytes = this.getReferenceBytes(reference, canonicalizationMethod);
                outputStream.write(referenceBytes);
            }
            byte[] byteArray = outputStream.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("AllDataObjectsTimestampData bytes:");
                LOG.trace(new String(byteArray));
            }
            inMemoryDocument = new InMemoryDocument(byteArray);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLSecurityException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to extract AllDataObjectsTimestampData. Reason : {}", (Object)e.getMessage(), (Object)e);
                } else {
                    LOG.warn("Unable to extract AllDataObjectsTimestampData. Reason : {}", (Object)e.getMessage());
                }
                return null;
            }
        }
        outputStream.close();
        return inMemoryDocument;
    }

    protected DSSDocument getIndividualDataObjectsTimestampData(TimestampToken timestampToken) {
        InMemoryDocument inMemoryDocument;
        if (!this.checkTimestampTokenIncludes(timestampToken)) {
            throw new IllegalArgumentException("The Included referencedData attribute is either not present or set to false!");
        }
        String canonicalizationMethod = timestampToken.getCanonicalizationMethod();
        List<TimestampInclude> includes = timestampToken.getTimestampIncludes();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            for (TimestampInclude include : includes) {
                Reference reference = this.getCorrespondingReference(include, this.references);
                if (reference != null) {
                    byte[] referenceBytes = this.getReferenceBytes(reference, canonicalizationMethod);
                    outputStream.write(referenceBytes);
                    continue;
                }
                LOG.warn("No ds:Reference found corresponding to an IndividualDataObjectsTimestamp include with URI '{}'!", (Object)include.getURI());
            }
            byte[] byteArray = outputStream.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("IndividualDataObjectsTimestampData bytes:");
                LOG.trace(new String(byteArray));
            }
            inMemoryDocument = new InMemoryDocument(byteArray);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLSecurityException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to extract IndividualDataObjectsTimestampData. Reason : {}", (Object)e.getMessage(), (Object)e);
                } else {
                    LOG.warn("Unable to extract IndividualDataObjectsTimestampData. Reason : {}", (Object)e.getMessage());
                }
                return null;
            }
        }
        outputStream.close();
        return inMemoryDocument;
    }

    private byte[] getReferenceBytes(Reference reference, String canonicalizationMethod) throws XMLSecurityException {
        byte[] referencedBytes = reference.getReferencedBytes();
        if (ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference)) && DomUtils.isDOM(referencedBytes)) {
            referencedBytes = DSSXMLUtils.canonicalize(canonicalizationMethod, referencedBytes);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ReferencedBytes : {}", (Object)new String(referencedBytes));
        }
        return referencedBytes;
    }

    private boolean checkTimestampTokenIncludes(TimestampToken timestampToken) {
        List<TimestampInclude> timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty(timestampIncludes)) {
            for (TimestampInclude timestampInclude : timestampIncludes) {
                if (timestampInclude.isReferencedData()) continue;
                return false;
            }
        }
        return true;
    }

    private Reference getCorrespondingReference(TimestampInclude timestampInclude, List<Reference> references) {
        String uri = timestampInclude.getURI();
        for (Reference reference : references) {
            if (!uri.equals(reference.getId())) continue;
            return reference;
        }
        return null;
    }

    @Override
    public DSSDocument getSignatureTimestampData(TimestampToken timestampToken) {
        try {
            byte[] timestampData = this.getSignatureTimestampData(timestampToken, null);
            return new InMemoryDocument(timestampData);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public byte[] getSignatureTimestampData(String canonicalizationMethod) {
        return this.getSignatureTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNATURE_VALUE_PATH, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signature timestamp canonicalized string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the SignatureTimestamp", e);
            }
        }
        buffer.close();
        return byArray;
    }

    @Override
    public DSSDocument getTimestampX1Data(TimestampToken timestampToken) {
        try {
            byte[] timestampX1Data = this.getTimestampX1Data(timestampToken, null, null);
            return new InMemoryDocument(timestampX1Data);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public byte[] getTimestampX1Data(String canonicalizationMethod, boolean en319132) {
        return this.getTimestampX1Data(null, canonicalizationMethod, en319132);
    }

    protected byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod, Boolean en319132) {
        byte[] byArray;
        XAdESAttribute timestampAttribute = timestampToken != null ? (XAdESAttribute)timestampToken.getTimestampAttribute() : null;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        en319132 = timestampToken != null ? this.checkAttributeNameMatches(timestampAttribute, XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2) : en319132.booleanValue();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNATURE_VALUE_PATH, canonicalizationMethod, buffer);
            Element unsignedProperties = this.getUnsignedSignaturePropertiesCanonicalizationCopy();
            if (unsignedProperties == null) {
                throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
            }
            XAdESUnsignedSigProperties xadesUnsignedSigProperties = new XAdESUnsignedSigProperties(unsignedProperties, this.xadesPaths);
            for (XAdESAttribute xadesAttribute : xadesUnsignedSigProperties.getAttributes()) {
                if (timestampAttribute != null && timestampAttribute.equals(xadesAttribute)) break;
                if (Boolean.TRUE.equals(en319132)) {
                    if (!this.checkAttributeNameMatches(xadesAttribute, XAdES132Element.SIGNATURE_TIMESTAMP, XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                    this.writeCanonicalizedValue(xadesAttribute, canonicalizationMethod, buffer);
                    continue;
                }
                if (!this.checkAttributeNameMatches(xadesAttribute, XAdES132Element.SIGNATURE_TIMESTAMP, XAdES132Element.COMPLETE_CERTIFICATE_REFS, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                this.writeCanonicalizedValue(xadesAttribute, canonicalizationMethod, buffer);
            }
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("X1Timestamp (SigAndRefsTimeStamp) canonicalized string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred when computing the SigAndRefsTimeStamp (X1Timestamp). Reason : %s", e.getMessage()), e);
            }
        }
        buffer.close();
        return byArray;
    }

    @Override
    public DSSDocument getTimestampX2Data(TimestampToken timestampToken) {
        try {
            byte[] timestampX2Data = this.getTimestampX2Data(timestampToken, null, null);
            return new InMemoryDocument(timestampX2Data);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public byte[] getTimestampX2Data(String canonicalizationMethod, boolean en319132) {
        return this.getTimestampX2Data(null, canonicalizationMethod, en319132);
    }

    protected byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod, Boolean en319132) {
        byte[] byArray;
        XAdESAttribute timestampAttribute = timestampToken != null ? (XAdESAttribute)timestampToken.getTimestampAttribute() : null;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        en319132 = timestampToken != null ? this.checkAttributeNameMatches(timestampAttribute, XAdES141Element.REFS_ONLY_TIMESTAMP_V2) : en319132.booleanValue();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            Element unsignedProperties = this.getUnsignedSignaturePropertiesCanonicalizationCopy();
            if (unsignedProperties == null) {
                throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
            }
            XAdESUnsignedSigProperties xadesUnsignedSigProperties = new XAdESUnsignedSigProperties(unsignedProperties, this.xadesPaths);
            for (XAdESAttribute xadesAttribute : xadesUnsignedSigProperties.getAttributes()) {
                if (timestampAttribute != null && timestampAttribute.equals(xadesAttribute)) break;
                if (Boolean.TRUE.equals(en319132)) {
                    if (!this.checkAttributeNameMatches(xadesAttribute, XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                    this.writeCanonicalizedValue(xadesAttribute, canonicalizationMethod, buffer);
                    continue;
                }
                if (!this.checkAttributeNameMatches(xadesAttribute, XAdES132Element.COMPLETE_CERTIFICATE_REFS, XAdES132Element.COMPLETE_REVOCATION_REFS, XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS, XAdES132Element.ATTRIBUTE_REVOCATION_REFS)) continue;
                this.writeCanonicalizedValue(xadesAttribute, canonicalizationMethod, buffer);
            }
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("TimestampX2Data (RefsOnlyTimeStamp) canonicalized string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred when computing the RefsOnlyTimeStamp (TimestampX2D). Reason : %s", e.getMessage()), e);
            }
        }
        buffer.close();
        return byArray;
    }

    @Override
    public DSSDocument getArchiveTimestampData(TimestampToken timestampToken) {
        try {
            byte[] archiveTimestampData = this.getArchiveTimestampData(timestampToken, null);
            return new InMemoryDocument(archiveTimestampData);
        }
        catch (DSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn(MESSAGE_IMPRINT_ERROR, timestampToken.getDSSIdAsString(), e.getMessage(), e);
            } else {
                LOG.warn(MESSAGE_IMPRINT_ERROR, (Object)timestampToken.getDSSIdAsString(), (Object)e.getMessage());
            }
            return null;
        }
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.getArchiveTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get archive timestamp data : {}", (Object)(timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            HashSet<String> referenceURIs = new HashSet<String>();
            for (Reference reference : this.references) {
                referenceURIs.add(DomUtils.getId(reference.getURI()));
                this.writeReferenceBytes(reference, canonicalizationMethod, buffer);
            }
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNED_INFO_PATH, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNATURE_VALUE_PATH, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(XMLDSigPaths.KEY_INFO_PATH, canonicalizationMethod, buffer);
            this.writeTimestampedUnsignedProperties(timestampToken, canonicalizationMethod, buffer);
            boolean xades141 = timestampToken == null || !ArchiveTimestampType.XAdES.equals((Object)timestampToken.getArchiveTimestampType());
            NodeList objects = this.getObjects();
            this.writeObjectBytes(objects, referenceURIs, canonicalizationMethod, xades141, buffer);
            byte[] bytes = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Data to TimeStamp:");
                LOG.trace(new String(bytes));
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException(String.format("An error occurred while building a message imprint data. Reason : %s", e.getMessage()), e);
            }
        }
        buffer.close();
        return byArray;
    }

    private void writeReferenceBytes(Reference reference, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        try {
            byte[] referencedBytes = this.getReferenceBytes(reference, canonicalizationMethod);
            if (referencedBytes == null) {
                throw new DSSException(String.format("No binaries found for URI '%s'", reference.getURI()));
            }
            buffer.write(referencedBytes);
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Unable to retrieve content for URI '%s' : %s", reference.getURI(), e.getMessage()), e);
        }
    }

    private void writeCanonicalizedValue(String xPathString, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        Element element = DomUtils.getElement(this.signature, xPathString);
        if (element != null) {
            buffer.write(DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, element));
        }
    }

    private Element getUnsignedSignaturePropertiesDom() {
        return DomUtils.getElement(this.signature, this.xadesPaths.getUnsignedSignaturePropertiesPath());
    }

    private Element getUnsignedSignaturePropertiesCanonicalizationCopy() {
        byte[] serializedDoc = DSSXMLUtils.serializeNode(this.signature.getOwnerDocument());
        Document recreatedDocument = DomUtils.buildDOM(serializedDoc);
        Element recreatedSignature = DomUtils.getElementById(recreatedDocument, DSSXMLUtils.getIDIdentifier(this.signature));
        return DomUtils.getElement(recreatedSignature, this.xadesPaths.getUnsignedSignaturePropertiesPath());
    }

    private void writeTimestampedUnsignedProperties(TimestampToken timestampToken, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        XAdESUnsignedSigProperties xadesUnsignedSigProperties = this.getXAdESUnsignedSignatureProperties(timestampToken);
        for (XAdESAttribute xadesAttribute : xadesUnsignedSigProperties.getAttributes()) {
            if (timestampToken != null && timestampToken.getTimestampAttribute().equals(xadesAttribute)) break;
            this.writeCanonicalizedValue(xadesAttribute, canonicalizationMethod, buffer);
        }
    }

    private XAdESUnsignedSigProperties getXAdESUnsignedSignatureProperties(TimestampToken timestampToken) {
        Element unsignedProperties = timestampToken == null ? this.getUnsignedSignaturePropertiesCanonicalizationCopy() : this.getUnsignedSignaturePropertiesDom();
        if (unsignedProperties == null) {
            throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
        }
        return new XAdESUnsignedSigProperties(unsignedProperties, this.xadesPaths);
    }

    private boolean checkAttributeNameMatches(XAdESAttribute attribute, DSSElement ... elements) {
        if (attribute != null) {
            return Arrays.stream(elements).map(DSSElement::getTagName).anyMatch(attribute.getName()::equals);
        }
        return false;
    }

    private void writeCanonicalizedValue(XAdESAttribute attribute, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, attribute.getElement());
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: Canonicalization: {} : \n{}", attribute.getName(), canonicalizationMethod, new String(canonicalizedValue));
        }
        buffer.write(canonicalizedValue);
    }

    private NodeList getObjects() {
        return DomUtils.getNodeList(this.signature, XMLDSigPaths.OBJECT_PATH);
    }

    private void writeObjectBytes(NodeList objects, Set<String> referenceURIs, String canonicalizationMethod, boolean xades141, ByteArrayOutputStream buffer) throws IOException {
        for (int ii = 0; ii < objects.getLength(); ++ii) {
            Node node = objects.item(ii);
            Element qualifyingProperties = DomUtils.getElement(node, this.xadesPaths.getCurrentQualifyingPropertiesPath());
            if (qualifyingProperties != null) continue;
            if (!xades141) {
                boolean contains;
                NamedNodeMap attributes = node.getAttributes();
                int length = attributes.getLength();
                String id = "";
                for (int jj = 0; jj < length; ++jj) {
                    Node item = attributes.item(jj);
                    String nodeName = item.getNodeName();
                    if (!Utils.areStringsEqualIgnoreCase("ID", nodeName)) continue;
                    id = item.getNodeValue();
                    break;
                }
                if (contains = referenceURIs.contains(id)) continue;
            }
            byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
            buffer.write(canonicalizedValue);
        }
    }
}

