/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.signature.manifest.AbstractManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.definition.ASiCAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESArchiveManifestBuilder
extends AbstractManifestBuilder {
    private final ASiCContent asicContent;
    private final DSSDocument lastArchiveManifest;
    private final DigestAlgorithm digestAlgorithm;
    private final String timestampFileUri;

    public ASiCEWithCAdESArchiveManifestBuilder(ASiCContent asicContent, DSSDocument lastArchiveManifest, DigestAlgorithm digestAlgorithm, String timestampFileUri) {
        this.asicContent = asicContent;
        this.lastArchiveManifest = lastArchiveManifest;
        this.digestAlgorithm = digestAlgorithm;
        this.timestampFileUri = timestampFileUri;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = DomUtils.createElementNS(documentDom, ASiCNamespace.NS, ASiCElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.timestampFileUri, MimeType.TST);
        for (DSSDocument signature : this.asicContent.getSignatureDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, signature, this.digestAlgorithm);
        }
        for (DSSDocument timestamp : this.asicContent.getTimestampDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, timestamp, this.digestAlgorithm);
        }
        for (DSSDocument manifest : this.asicContent.getAllManifestDocuments()) {
            if (this.lastArchiveManifest == manifest) {
                this.addDataObjectReferenceForRootArchiveManifest(documentDom, asicManifestDom, this.lastArchiveManifest, this.digestAlgorithm);
                continue;
            }
            this.addDataObjectReference(documentDom, asicManifestDom, manifest, this.digestAlgorithm);
        }
        for (DSSDocument document : this.asicContent.getSignedDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        return DomUtils.createDssDocumentFromDomDocument(documentDom, "META-INF/ASiCArchiveManifest.xml");
    }

    private Element addDataObjectReferenceForRootArchiveManifest(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceElement = this.addDataObjectReference(documentDom, asicManifestDom, document, digestAlgorithm);
        dataObjectReferenceElement.setAttribute(ASiCAttribute.ROOTFILE.getAttributeName(), "true");
        return dataObjectReferenceElement;
    }
}

