/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.List;

public class ASiCWithCAdESUtils {
    public static final String DEFAULT_ARCHIVE_MANIFEST_FILENAME = "META-INF/ASiCArchiveManifest.xml";
    public static final String ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE = "META-INF/signature001.p7s";
    public static final String ZIP_ENTRY_ASICE_METAINF_TIMESTAMP = "META-INF/timestamp001.tst";

    private ASiCWithCAdESUtils() {
    }

    public static DSSDocument getSignedDocument(ASiCContent extractResult, String signatureFilename) {
        ASiCContainerType type = extractResult.getContainerType();
        if (ASiCContainerType.ASiC_S.equals((Object)type) && extractResult.getSignedDocuments().size() == 1) {
            return extractResult.getSignedDocuments().iterator().next();
        }
        if (ASiCContainerType.ASiC_E.equals((Object)type)) {
            List<DSSDocument> manifestDocuments = extractResult.getManifestDocuments();
            if (manifestDocuments.size() == 1) {
                return manifestDocuments.iterator().next();
            }
            DSSDocument linkedManifest = ASiCWithCAdESManifestParser.getLinkedManifest(extractResult.getManifestDocuments(), signatureFilename);
            if (linkedManifest != null) {
                return linkedManifest;
            }
            return null;
        }
        throw new IllegalInputException("Unable to extract a signed document. Reason : Unknown asic container type.");
    }

    public static boolean isCoveredByManifest(List<DSSDocument> manifestDocuments, String signatureFilename) {
        if (Utils.isCollectionNotEmpty(manifestDocuments)) {
            for (DSSDocument archiveManifest : manifestDocuments) {
                ManifestFile manifestFile = ASiCWithCAdESManifestParser.getManifestFile(archiveManifest);
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    if (signatureFilename == null || !signatureFilename.equals(entry.getFileName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getSignatureFileName(List<DSSDocument> existingSignatures, String expectedSignatureFileName) {
        if (Utils.isStringNotBlank(expectedSignatureFileName)) {
            ASiCWithCAdESUtils.assertSignatureNameIsValid(existingSignatures, expectedSignatureFileName);
            return "META-INF/" + expectedSignatureFileName;
        }
        int num = Utils.collectionSize(existingSignatures) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_SIGNATURE.replace("001", ASiCUtils.getPadNumber(num));
    }

    private static void assertSignatureNameIsValid(List<DSSDocument> existingSignatures, String signatureFileName) {
        if (DSSUtils.getDocumentNames(existingSignatures).contains(signatureFileName)) {
            throw new IllegalArgumentException(String.format("The signature file with name '%s' already exists within the ASiC Container!", signatureFileName));
        }
    }

    public static String getTimestampFileName(List<DSSDocument> existingTimestamps) {
        int num = Utils.collectionSize(existingTimestamps) + 1;
        return ZIP_ENTRY_ASICE_METAINF_TIMESTAMP.replace("001", ASiCUtils.getPadNumber(num));
    }
}

