/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractASiCContentBuilder {
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file";

    public ASiCContent build(List<DSSDocument> documents, ASiCContainerType asicContainerType) {
        DSSDocument archiveDocument;
        if (Utils.isCollectionNotEmpty(documents) && documents.size() == 1 && ASiCUtils.isZip(archiveDocument = documents.get(0)) && this.isAcceptableContainerFormat(archiveDocument)) {
            return this.fromZipArchive(archiveDocument, asicContainerType);
        }
        return this.fromFiles(documents, asicContainerType);
    }

    protected abstract boolean isAcceptableContainerFormat(DSSDocument var1);

    private ASiCContent fromZipArchive(DSSDocument archiveDoc, ASiCContainerType asicContainerType) {
        AbstractASiCContainerExtractor extractor = this.getContainerExtractor(archiveDoc);
        ASiCContent asicContent = extractor.extract();
        this.assertContainerTypeValid(asicContent, asicContainerType);
        return asicContent;
    }

    private ASiCContent fromFiles(List<DSSDocument> documents, ASiCContainerType asicContainerType) {
        this.assertDocumentNamesDefined(documents);
        ASiCContent asicContent = new ASiCContent();
        asicContent.setContainerType(asicContainerType);
        asicContent.setSignedDocuments(documents);
        return asicContent;
    }

    protected abstract AbstractASiCContainerExtractor getContainerExtractor(DSSDocument var1);

    private void assertContainerTypeValid(ASiCContent result, ASiCContainerType asicContainerType) {
        if (ASiCUtils.filesContainSignatures(DSSUtils.getDocumentNames(result.getAllDocuments())) && Utils.isCollectionEmpty(result.getSignatureDocuments())) {
            throw new UnsupportedOperationException("Container type doesn't match");
        }
        if (asicContainerType != result.getContainerType()) {
            throw new IllegalInputException(String.format("The provided container of type '%s' does not correspond the expected format '%s'!", new Object[]{result.getContainerType(), asicContainerType}));
        }
    }

    private void assertDocumentNamesDefined(List<DSSDocument> documents) {
        List<DSSDocument> unnamedDocuments = this.getDocumentsWithoutNames(documents);
        if (unnamedDocuments.size() == 1) {
            DSSDocument dssDocument = unnamedDocuments.iterator().next();
            dssDocument.setName(ZIP_ENTRY_DETACHED_FILE);
        } else {
            for (int ii = 0; ii < unnamedDocuments.size(); ++ii) {
                DSSDocument dssDocument = unnamedDocuments.get(ii);
                dssDocument.setName("detached-file-" + ii);
            }
        }
    }

    private List<DSSDocument> getDocumentsWithoutNames(List<DSSDocument> documents) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (DSSDocument document : documents) {
            if (!Utils.isStringBlank(document.getName())) continue;
            result.add(document);
        }
        return result;
    }
}

