/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.List;

public abstract class AbstractASiCDataToSignHelperBuilder {
    protected DSSDocument getASiCSSignedDocument(List<DSSDocument> filesToBeSigned, Date signingDate, ASiCParameters asicParameters) {
        if (Utils.collectionSize(filesToBeSigned) == 1) {
            return filesToBeSigned.iterator().next();
        }
        if (Utils.collectionSize(filesToBeSigned) > 1) {
            return this.createPackageZip(filesToBeSigned, signingDate, ASiCUtils.getZipComment(asicParameters));
        }
        throw new IllegalArgumentException("At least one file to be signed shall be provided!");
    }

    protected DSSDocument createPackageZip(List<DSSDocument> documents, Date signingDate, String zipComment) {
        DSSDocument packageZip = ZipUtils.getInstance().createZipArchive(documents, signingDate, zipComment);
        packageZip.setName("package.zip");
        packageZip.setMimeType(MimeType.ZIP);
        return packageZip;
    }
}

