/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.ArrayList;
import java.util.List;

public final class OpenDocumentSupportUtils {
    private static final String EXTERNAL_DATA = "external-data/";

    private OpenDocumentSupportUtils() {
    }

    public static List<DSSDocument> getOpenDocumentCoverage(ASiCContent asicContent) {
        ArrayList<DSSDocument> docs = new ArrayList<DSSDocument>();
        docs.addAll(asicContent.getSignedDocuments());
        docs.addAll(asicContent.getManifestDocuments());
        docs.addAll(asicContent.getArchiveManifestDocuments());
        docs.addAll(asicContent.getTimestampDocuments());
        docs.addAll(asicContent.getUnsupportedDocuments());
        docs.add(asicContent.getMimeTypeDocument());
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (DSSDocument doc : docs) {
            if (OpenDocumentSupportUtils.isExternalDataDocument(doc)) continue;
            result.add(doc);
        }
        return result;
    }

    public static boolean isExternalDataDocument(DSSDocument document) {
        return document.getName() != null && document.getName().startsWith(EXTERNAL_DATA);
    }
}

