/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.signature.AbstractGetDataToSignHelper;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class DataToSignASiCEWithXAdESHelper
extends AbstractGetDataToSignHelper
implements GetDataToSignASiCWithXAdESHelper {
    private static final String ZIP_ENTRY_ASICE_METAINF_XADES_SIGNATURE = "META-INF/signatures001.xml";
    private final ASiCParameters asicParameters;

    public DataToSignASiCEWithXAdESHelper(ASiCContent asicContent, ASiCParameters asicParameters) {
        super(asicContent);
        this.asicParameters = asicParameters;
    }

    @Override
    public List<DSSDocument> getToBeSigned() {
        return this.asicContent.getSignedDocuments();
    }

    @Override
    public String getSignatureFilename() {
        if (Utils.isStringNotBlank(this.asicParameters.getSignatureFileName())) {
            return "META-INF/" + this.asicParameters.getSignatureFileName();
        }
        List<DSSDocument> existingSignatures = this.asicContent.getSignatureDocuments();
        if (Utils.isCollectionNotEmpty(existingSignatures)) {
            return ZIP_ENTRY_ASICE_METAINF_XADES_SIGNATURE.replace("001", this.getSignatureNumber(existingSignatures));
        }
        return ZIP_ENTRY_ASICE_METAINF_XADES_SIGNATURE;
    }

    private String getSignatureNumber(List<DSSDocument> existingSignatures) {
        int signatureNumber = existingSignatures.size() + 1;
        String sigNumberStr = String.valueOf(signatureNumber);
        String zeroPad = "000";
        return zeroPad.substring(sigNumberStr.length()) + sigNumberStr;
    }

    @Override
    public String getTimestampFilename() {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-E + XAdES");
    }

    @Override
    public boolean isOpenDocument() {
        return false;
    }
}

