/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineB;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CMSSignedDataBuilder {
    private final CertificateVerifier certificateVerifier;

    public CMSSignedDataBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected CMSSignedDataGenerator createCMSSignedDataGenerator(CAdESSignatureParameters parameters, ContentSigner contentSigner, SignerInfoGeneratorBuilder signerInfoGeneratorBuilder, CMSSignedData originalSignedData) {
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            SignerInfoGenerator signerInfoGenerator = this.getSignerInfoGenerator(signerInfoGeneratorBuilder, contentSigner, parameters);
            generator.addSignerInfoGenerator(signerInfoGenerator);
            LinkedList<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
            if (originalSignedData != null) {
                generator.addSigners(originalSignedData.getSignerInfos());
                generator.addAttributeCertificates(originalSignedData.getAttributeCertificates());
                generator.addCRLs(originalSignedData.getCRLs());
                generator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, originalSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic));
                generator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, originalSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response));
                Store<X509CertificateHolder> certificates = originalSignedData.getCertificates();
                Collection<X509CertificateHolder> certificatesMatches = certificates.getMatches(null);
                for (X509CertificateHolder certificatesMatch : certificatesMatches) {
                    CertificateToken token = DSSASN1Utils.getCertificate(certificatesMatch);
                    if (certificateChain.contains(token)) continue;
                    certificateChain.add(token);
                }
            }
            JcaCertStore jcaCertStore = this.getJcaCertStore(certificateChain, parameters);
            generator.addCertificates(jcaCertStore);
            return generator;
        }
        catch (CMSException | OperatorCreationException e) {
            throw new DSSException(String.format("Unable to create a CMSSignedDataGenerator. Reason : %s", e.getMessage()), e);
        }
    }

    SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CAdESSignatureParameters parameters, boolean includeUnsignedAttributes) {
        return this.getSignerInfoGeneratorBuilder(digestCalculatorProvider, parameters, includeUnsignedAttributes, null);
    }

    SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CAdESSignatureParameters parameters, boolean includeUnsignedAttributes, DSSDocument contentToSign) {
        CAdESLevelBaselineB cadesProfile = new CAdESLevelBaselineB(contentToSign);
        AttributeTable signedAttributes = cadesProfile.getSignedAttributes(parameters);
        AttributeTable unsignedAttributes = null;
        if (includeUnsignedAttributes) {
            unsignedAttributes = cadesProfile.getUnsignedAttributes();
        }
        return this.getSignerInfoGeneratorBuilder(digestCalculatorProvider, signedAttributes, unsignedAttributes);
    }

    private SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, AttributeTable signedAttributes, AttributeTable unsignedAttributes) {
        if (DSSASN1Utils.isEmpty(signedAttributes)) {
            signedAttributes = null;
        }
        DefaultSignedAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator(signedAttributes);
        if (DSSASN1Utils.isEmpty(unsignedAttributes)) {
            unsignedAttributes = null;
        }
        SimpleAttributeTableGenerator unsignedAttributeGenerator = new SimpleAttributeTableGenerator(unsignedAttributes);
        SignerInfoGeneratorBuilder sigInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(digestCalculatorProvider);
        sigInfoGeneratorBuilder.setSignedAttributeGenerator(signedAttributeGenerator);
        sigInfoGeneratorBuilder.setUnsignedAttributeGenerator(unsignedAttributeGenerator);
        return sigInfoGeneratorBuilder;
    }

    private SignerInfoGenerator getSignerInfoGenerator(SignerInfoGeneratorBuilder signerInfoGeneratorBuilder, ContentSigner contentSigner, CAdESSignatureParameters parameters) throws OperatorCreationException {
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        if (signingCertificate == null && parameters.isGenerateTBSWithoutCertificate()) {
            SignerId signerId = new SignerId(DSSUtils.EMPTY_BYTE_ARRAY);
            return signerInfoGeneratorBuilder.build(contentSigner, signerId.getSubjectKeyIdentifier());
        }
        X509CertificateHolder certHolder = DSSASN1Utils.getX509CertificateHolder(signingCertificate);
        return signerInfoGeneratorBuilder.build(contentSigner, certHolder);
    }

    private JcaCertStore getJcaCertStore(Collection<CertificateToken> certificateChain, CAdESSignatureParameters parameters) {
        BaselineBCertificateSelector certificateSelectors = new BaselineBCertificateSelector(this.certificateVerifier, parameters);
        List<CertificateToken> certificatesToAdd = parameters.getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate() ? new ArrayList<CertificateToken>() : certificateSelectors.getCertificates();
        for (CertificateToken certificateToken : certificatesToAdd) {
            if (certificateChain.contains(certificateToken)) continue;
            certificateChain.add(certificateToken);
        }
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (CertificateToken certificateInChain : certificateChain) {
                certs.add(certificateInChain.getCertificate());
            }
            return new JcaCertStore(certs);
        }
        catch (CertificateEncodingException e) {
            throw new DSSException(String.format("Unable to get JcaCertStore. Reason : %s", e.getMessage()), e);
        }
    }

    public CMSSignedData extendCMSSignedData(CMSSignedData cmsSignedData, ValidationData validationDataForInclusion) {
        Store<X509CertificateHolder> certificatesStore = cmsSignedData.getCertificates();
        Set<CertificateToken> certificates = validationDataForInclusion.getCertificateTokens();
        HashSet<X509CertificateHolder> newCertificateStore = new HashSet<X509CertificateHolder>(certificatesStore.getMatches(null));
        for (CertificateToken certificateToken : certificates) {
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(certificateToken);
            if (newCertificateStore.contains(x509CertificateHolder)) continue;
            newCertificateStore.add(x509CertificateHolder);
        }
        certificatesStore = new CollectionStore<X509CertificateHolder>(newCertificateStore);
        Store<X509AttributeCertificateHolder> attributeCertificatesStore = cmsSignedData.getAttributeCertificates();
        Store<X509CRLHolder> crlsStore = cmsSignedData.getCRLs();
        HashSet<X509CRLHolder> newCrlsStore = new HashSet<X509CRLHolder>(crlsStore.getMatches(null));
        Set<CRLToken> crlTokens = validationDataForInclusion.getCrlTokens();
        for (CRLToken crlToken : crlTokens) {
            X509CRLHolder x509CRLHolder = this.getX509CrlHolder(crlToken);
            if (newCrlsStore.contains(x509CRLHolder)) continue;
            newCrlsStore.add(x509CRLHolder);
        }
        CollectionStore otherRevocationInfoFormatStoreBasic = cmsSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        HashSet newOtherRevocationInfoFormatStore = new HashSet(otherRevocationInfoFormatStoreBasic.getMatches(null));
        Set<OCSPToken> ocspTokens = validationDataForInclusion.getOcspTokens();
        for (OCSPToken ocspToken : ocspTokens) {
            Object ocspResponseASN1Primitive;
            BasicOCSPResp basicOCSPResp = ocspToken.getBasicOCSPResp();
            if (basicOCSPResp == null || newOtherRevocationInfoFormatStore.contains(ocspResponseASN1Primitive = DSSASN1Utils.toASN1Primitive(DSSASN1Utils.getEncoded(basicOCSPResp)))) continue;
            newOtherRevocationInfoFormatStore.add(ocspResponseASN1Primitive);
        }
        otherRevocationInfoFormatStoreBasic = new CollectionStore(newOtherRevocationInfoFormatStore);
        for (Object ocsp : otherRevocationInfoFormatStoreBasic.getMatches(null)) {
            newCrlsStore.add((X509CRLHolder)((Object)new OtherRevocationInfoFormat(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1Encodable)ocsp)));
        }
        Store otherRevocationInfoFormatStoreOcsp = cmsSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        for (Object ocsp : otherRevocationInfoFormatStoreOcsp.getMatches(null)) {
            newCrlsStore.add((X509CRLHolder)((Object)new OtherRevocationInfoFormat(CMSObjectIdentifiers.id_ri_ocsp_response, (ASN1Encodable)ocsp)));
        }
        crlsStore = new CollectionStore<X509CRLHolder>(newCrlsStore);
        try {
            return CMSSignedData.replaceCertificatesAndCRLs(cmsSignedData, certificatesStore, attributeCertificatesStore, crlsStore);
        }
        catch (CMSException e) {
            throw new DSSException(String.format("Unable to re-create a CMS signature. Reason : %s", e.getMessage()), e);
        }
    }

    private X509CRLHolder getX509CrlHolder(CRLToken crlToken) {
        X509CRLHolder x509CRLHolder;
        block8: {
            InputStream is = crlToken.getCRLStream();
            try {
                x509CRLHolder = new X509CRLHolder(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Unable to convert X509CRL to X509CRLHolder", e);
                }
            }
            is.close();
        }
        return x509CRLHolder;
    }
}

