/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.validation.SignatureAttribute;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESAttribute
implements SignatureAttribute {
    private static final long serialVersionUID = 7020534361457301562L;
    private static final Logger LOG = LoggerFactory.getLogger(CAdESAttribute.class);
    private final Attribute attribute;

    CAdESAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public ASN1ObjectIdentifier getASN1Oid() {
        return this.attribute.getAttrType();
    }

    public ASN1Set getAttrValues() {
        return this.attribute.getAttrValues();
    }

    public ASN1Encodable getASN1Object() {
        return this.attribute.getAttrValues().getObjectAt(0);
    }

    public boolean isTimeStampToken() {
        return DSSASN1Utils.getTimestampOids().contains(this.getASN1Oid());
    }

    public TimeStampToken toTimeStampToken() {
        if (this.isTimeStampToken()) {
            try {
                return DSSASN1Utils.getTimeStampToken(this.attribute);
            }
            catch (Exception e) {
                LOG.warn("Unable to build a timestamp token from the attribute [{}] : {}", (Object)this, (Object)e.getMessage());
            }
        } else {
            LOG.warn("The given attribute [{}] is not a timestamp! Unable to build a TimeStampToken.", (Object)this);
        }
        return null;
    }

    public String toString() {
        ASN1ObjectIdentifier asn1Oid = this.getASN1Oid();
        if (asn1Oid != null) {
            return asn1Oid.toString();
        }
        return "";
    }
}

