/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.validation.CAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSDocumentValidator
extends SignedDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CMSDocumentValidator.class);
    protected CMSSignedData cmsSignedData;

    CMSDocumentValidator() {
        this(new CAdESSignatureScopeFinder());
    }

    CMSDocumentValidator(SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        super(signatureScopeFinder);
    }

    public CMSDocumentValidator(CMSSignedData cmsSignedData) {
        this();
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentValidator(DSSDocument document) {
        this();
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
        this.cmsSignedData = this.toCMSSignedData(document);
    }

    private CMSSignedData toCMSSignedData(DSSDocument document) {
        try {
            return DSSUtils.toCMSSignedData(document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("A CMS file is expected : %s", e.getMessage()), e);
        }
    }

    protected CMSDocumentValidator(DSSDocument document, SignatureScopeFinder<CAdESSignature> signatureScopeFinder) {
        this(signatureScopeFinder);
        this.document = document;
        this.cmsSignedData = DSSUtils.toCMSSignedData(document);
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte(dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag(firstByte)) {
            return !DSSUtils.isTimestampToken(dssDocument);
        }
        return false;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            for (SignerInformation signerInformation : this.cmsSignedData.getSignerInfos().getSigners()) {
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation);
                if (this.document != null) {
                    cadesSignature.setSignatureFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setContainerContents(this.containerContents);
                cadesSignature.setManifestFile(this.manifestFile);
                cadesSignature.setSigningCertificateSource(this.signingCertificateSource);
                cadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                signatures.add(cadesSignature);
            }
        }
        return signatures;
    }

    @Override
    protected CAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new CAdESDiagnosticDataBuilder();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
        try {
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        catch (DSSException e) {
            LOG.error("Cannot retrieve a list of original documents");
            return Collections.emptyList();
        }
    }
}

