/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.definition;

import eu.europa.esig.dss.definition.DSSAttribute;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSException;

public class XPathExpressionBuilder {
    private static final String ALL_PATH = "//";
    private static final String FROM_CURRENT_POSITION_PATH = "./";
    private static final String ALL_FROM_CURRENT_POSITION_PATH = ".//";
    private static final String COLON_PATH = ":";
    private static final String SLASH_PATH = "/";
    private static final String ATTRIBUTE_PATH = "@";
    private boolean fromCurrentPosition = false;
    private boolean all = false;
    private DSSElement[] elements;
    private DSSAttribute attribute;
    private DSSElement notParentOf;

    public XPathExpressionBuilder fromCurrentPosition() {
        return this.fromCurrentPosition(true);
    }

    public XPathExpressionBuilder fromCurrentPosition(boolean fromCurrentPosition) {
        this.fromCurrentPosition = fromCurrentPosition;
        return this;
    }

    public XPathExpressionBuilder all() {
        return this.all(true);
    }

    public XPathExpressionBuilder all(boolean all) {
        this.all = all;
        return this;
    }

    public XPathExpressionBuilder element(DSSElement element) {
        this.elements = new DSSElement[]{element};
        return this;
    }

    public XPathExpressionBuilder elements(DSSElement[] elements) {
        this.elements = elements;
        return this;
    }

    public XPathExpressionBuilder notParentOf(DSSElement notParentOf) {
        this.notParentOf = notParentOf;
        return this;
    }

    public XPathExpressionBuilder attribute(DSSAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        if (this.all && this.fromCurrentPosition) {
            sb.append(ALL_FROM_CURRENT_POSITION_PATH);
        } else if (this.fromCurrentPosition) {
            sb.append(FROM_CURRENT_POSITION_PATH);
        } else if (this.all) {
            sb.append(ALL_PATH);
        } else {
            throw new DSSException("Unsupported operation");
        }
        int nbElements = this.elements.length;
        for (int i = 0; i < nbElements; ++i) {
            sb.append((CharSequence)this.getElement(this.elements[i]));
            if (i >= nbElements - 1) continue;
            sb.append(SLASH_PATH);
        }
        if (this.notParentOf != null) {
            sb.append((CharSequence)this.getNotParent(this.notParentOf));
        }
        if (this.attribute != null) {
            sb.append(SLASH_PATH).append((CharSequence)this.getAttribute(this.attribute));
        }
        return sb.toString();
    }

    private StringBuilder getElement(DSSElement element) {
        StringBuilder sb = new StringBuilder();
        DSSNamespace namespace = element.getNamespace();
        if (namespace != null) {
            sb.append(namespace.getPrefix());
            sb.append(COLON_PATH);
        }
        sb.append(element.getTagName());
        return sb;
    }

    private StringBuilder getNotParent(DSSElement currentNotParentOf) {
        StringBuilder sb = new StringBuilder();
        sb.append("[not(parent::");
        sb.append((CharSequence)this.getElement(currentNotParentOf));
        sb.append(")]");
        return sb;
    }

    private StringBuilder getAttribute(DSSAttribute currentAttribute) {
        StringBuilder sb = new StringBuilder();
        sb.append(ATTRIBUTE_PATH);
        sb.append(currentAttribute.getAttributeName());
        return sb;
    }
}

