/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDocMDP;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFLockDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureField;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicyDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSPDocSpecification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignaturePolicyStore;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerDocumentRepresentations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlUserNotice;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SignatureWrapper
extends AbstractTokenProxy {
    private final XmlSignature signature;

    public SignatureWrapper(XmlSignature signature) {
        Objects.requireNonNull(signature, "XmlSignature cannot be null!");
        this.signature = signature;
    }

    @Override
    public String getId() {
        return this.signature.getId();
    }

    public String getDAIdentifier() {
        return this.signature.getDAIdentifier();
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return this.signature.getDigestMatchers();
    }

    public XmlDigestMatcher getMessageDigest() {
        List<XmlDigestMatcher> digestMatchers = this.signature.getDigestMatchers();
        for (XmlDigestMatcher xmlDigestMatcher : digestMatchers) {
            if (DigestMatcherType.MESSAGE_DIGEST != xmlDigestMatcher.getType()) continue;
            return xmlDigestMatcher;
        }
        return null;
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.signature.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.signature.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.signature.getSigningCertificate();
    }

    @Override
    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(this.signature.getFoundCertificates());
    }

    @Override
    public FoundRevocationsProxy foundRevocations() {
        return new FoundRevocationsProxy(this.signature.getFoundRevocations());
    }

    public String getSignatureFilename() {
        return this.signature.getSignatureFilename();
    }

    public boolean isStructuralValidationValid() {
        return this.signature.getStructuralValidation() != null && this.signature.getStructuralValidation().isValid() != false;
    }

    public List<String> getStructuralValidationMessages() {
        XmlStructuralValidation structuralValidation = this.signature.getStructuralValidation();
        if (structuralValidation != null) {
            return structuralValidation.getMessages();
        }
        return Collections.emptyList();
    }

    public Date getClaimedSigningTime() {
        return this.signature.getClaimedSigningTime();
    }

    public String getContentType() {
        return this.signature.getContentType();
    }

    public String getMimeType() {
        return this.signature.getMimeType();
    }

    public String getContentHints() {
        return this.signature.getContentHints();
    }

    public String getContentIdentifier() {
        return this.signature.getContentIdentifier();
    }

    public boolean isCounterSignature() {
        return this.signature.isCounterSignature() != null && this.signature.isCounterSignature() != false;
    }

    public boolean isSignatureDuplicated() {
        return this.signature.isDuplicated() != null && this.signature.isDuplicated() != false;
    }

    public XmlSignatureDigestReference getSignatureDigestReference() {
        return this.signature.getSignatureDigestReference();
    }

    public XmlDigestAlgoAndValue getDataToBeSignedRepresentation() {
        return this.signature.getDataToBeSignedRepresentation();
    }

    public List<TimestampWrapper> getTimestampList() {
        ArrayList<TimestampWrapper> tsps = new ArrayList<TimestampWrapper>();
        List<XmlFoundTimestamp> foundTimestamps = this.signature.getFoundTimestamps();
        for (XmlFoundTimestamp xmlFoundTimestamp : foundTimestamps) {
            tsps.add(new TimestampWrapper(xmlFoundTimestamp.getTimestamp()));
        }
        return tsps;
    }

    public List<TimestampWrapper> getTimestampListByType(TimestampType timestampType) {
        ArrayList<TimestampWrapper> result = new ArrayList<TimestampWrapper>();
        List<TimestampWrapper> all = this.getTimestampList();
        for (TimestampWrapper tsp : all) {
            if (!timestampType.equals((Object)tsp.getType())) continue;
            result.add(tsp);
        }
        return result;
    }

    public boolean isSignatureProductionPlacePresent() {
        return this.signature.getSignatureProductionPlace() != null;
    }

    public String getStreetAddress() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getStreetAddress();
        }
        return null;
    }

    public String getCity() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getCity();
        }
        return null;
    }

    public String getCountryName() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getCountryName();
        }
        return null;
    }

    public String getPostOfficeBoxNumber() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getPostOfficeBoxNumber();
        }
        return null;
    }

    public String getPostalCode() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getPostalCode();
        }
        return null;
    }

    public String getStateOrProvince() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getStateOrProvince();
        }
        return null;
    }

    public List<String> getPostalAddress() {
        if (this.isSignatureProductionPlacePresent()) {
            return this.signature.getSignatureProductionPlace().getPostalAddress();
        }
        return Collections.emptyList();
    }

    public SignatureLevel getSignatureFormat() {
        return this.signature.getSignatureFormat();
    }

    public String getErrorMessage() {
        return this.signature.getErrorMessage();
    }

    public boolean isSigningCertificateIdentified() {
        CertificateWrapper signingCertificate = this.getSigningCertificate();
        CertificateRefWrapper signingCertificateReference = this.getSigningCertificateReference();
        if (signingCertificate != null && signingCertificateReference != null) {
            return signingCertificateReference.isDigestValueMatch() && (!signingCertificateReference.isIssuerSerialPresent() || signingCertificateReference.isIssuerSerialMatch());
        }
        return false;
    }

    public String getPolicyId() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getId();
        }
        return "";
    }

    public boolean isPolicyZeroHash() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDigestAlgoAndValue() != null) {
            return policy.getDigestAlgoAndValue().isZeroHash() != null && policy.getDigestAlgoAndValue().isZeroHash() != false;
        }
        return false;
    }

    public XmlPolicyDigestAlgoAndValue getPolicyDigestAlgoAndValue() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getDigestAlgoAndValue();
        }
        return null;
    }

    public boolean isPolicyStorePresent() {
        return this.signature.getSignaturePolicyStore() != null;
    }

    public String getPolicyStoreId() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getId();
        }
        return null;
    }

    public String getPolicyStoreDescription() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getDescription();
        }
        return null;
    }

    public XmlDigestAlgoAndValue getPolicyStoreDigestAlgoAndValue() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getDigestAlgoAndValue();
        }
        return null;
    }

    public List<String> getPolicyStoreDocumentationReferences() {
        XmlSignaturePolicyStore policyStore = this.signature.getSignaturePolicyStore();
        if (policyStore != null) {
            return policyStore.getDocumentationReferences();
        }
        return Collections.emptyList();
    }

    public boolean isBLevelTechnicallyValid() {
        return this.isSignatureValid();
    }

    public boolean isThereXLevel() {
        List<TimestampWrapper> timestampLevelX = this.getTimestampLevelX();
        return timestampLevelX != null && !timestampLevelX.isEmpty();
    }

    public boolean isXLevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getTimestampLevelX();
        return this.isAtLeastOneTimestampValid(timestamps);
    }

    public List<TimestampWrapper> getTimestampLevelX() {
        List<TimestampWrapper> timestamps = this.getTimestampListByType(TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
        timestamps.addAll(this.getTimestampListByType(TimestampType.VALIDATION_DATA_TIMESTAMP));
        return timestamps;
    }

    public boolean isThereALevel() {
        List<TimestampWrapper> timestamps = this.getALevelTimestamps();
        return timestamps != null && !timestamps.isEmpty();
    }

    public boolean isALevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getALevelTimestamps();
        return this.isAtLeastOneTimestampValid(timestamps);
    }

    public List<TimestampWrapper> getALevelTimestamps() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>(this.getArchiveTimestamps());
        timestamps.addAll(this.getDocumentTimestamps(true));
        return timestamps;
    }

    public List<TimestampWrapper> getArchiveTimestamps() {
        return this.getTimestampListByType(TimestampType.ARCHIVE_TIMESTAMP);
    }

    public boolean isThereTLevel() {
        List<TimestampWrapper> timestamps = this.getTLevelTimestamps();
        return timestamps != null && !timestamps.isEmpty();
    }

    public boolean isTLevelTechnicallyValid() {
        List<TimestampWrapper> timestamps = this.getTLevelTimestamps();
        return this.isAtLeastOneTimestampValid(timestamps);
    }

    public List<TimestampWrapper> getTLevelTimestamps() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>(this.getSignatureTimestamps());
        timestamps.addAll(this.getDocumentTimestamps());
        return timestamps;
    }

    public List<TimestampWrapper> getContentTimestamps() {
        List<TimestampWrapper> timestamps = this.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
        timestamps.addAll(this.getTimestampListByType(TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP));
        timestamps.addAll(this.getTimestampListByType(TimestampType.ALL_DATA_OBJECTS_TIMESTAMP));
        return timestamps;
    }

    public List<TimestampWrapper> getAllTimestampsProducedAfterSignatureCreation() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>();
        for (TimestampType timestampType : TimestampType.values()) {
            if (timestampType.isContentTimestamp()) continue;
            timestamps.addAll(this.getTimestampListByType(timestampType));
        }
        return timestamps;
    }

    public List<TimestampWrapper> getSignatureTimestamps() {
        return this.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP);
    }

    public List<TimestampWrapper> getDocumentTimestamps() {
        return this.getTimestampListByType(TimestampType.DOCUMENT_TIMESTAMP);
    }

    private List<TimestampWrapper> getDocumentTimestamps(boolean coversLTLevel) {
        ArrayList<TimestampWrapper> timestampWrappers = new ArrayList<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : this.getDocumentTimestamps()) {
            if (coversLTLevel != this.coversLTLevel(timestampWrapper)) continue;
            timestampWrappers.add(timestampWrapper);
        }
        return timestampWrappers;
    }

    private boolean coversLTLevel(TimestampWrapper timestampWrapper) {
        return ArchiveTimestampType.PAdES.equals((Object)timestampWrapper.getArchiveTimestampType()) && this.coversRevocationDataForCertificateChain(timestampWrapper, this.getCertificateChain());
    }

    private boolean coversRevocationDataForCertificateChain(TimestampWrapper timestampWrapper, List<CertificateWrapper> certificateChain) {
        List<RevocationWrapper> timestampedRevocations = timestampWrapper.getTimestampedRevocations();
        for (CertificateWrapper certificateWrapper : certificateChain) {
            List<CertificateRevocationWrapper> certificateRevocationData = certificateWrapper.getCertificateRevocationData();
            if (certificateRevocationData == null || certificateRevocationData.isEmpty()) continue;
            boolean revocationDataCovered = false;
            for (RevocationWrapper revocationWrapper : certificateRevocationData) {
                if (!timestampedRevocations.contains(revocationWrapper)) continue;
                revocationDataCovered = true;
                break;
            }
            if (revocationDataCovered) continue;
            return false;
        }
        return true;
    }

    private boolean isAtLeastOneTimestampValid(List<TimestampWrapper> timestampList) {
        if (timestampList != null && !timestampList.isEmpty()) {
            for (TimestampWrapper timestamp : timestampList) {
                boolean messageImprintIntact;
                boolean signatureValid = timestamp.isSignatureValid();
                XmlDigestMatcher messageImprint = timestamp.getMessageImprint();
                boolean bl = messageImprintIntact = messageImprint.isDataFound() && messageImprint.isDataIntact();
                if (!signatureValid || !messageImprintIntact) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTimestampIdsList() {
        ArrayList<String> result = new ArrayList<String>();
        List<TimestampWrapper> timestamps = this.getTimestampList();
        if (timestamps != null) {
            for (TimestampWrapper tsp : timestamps) {
                result.add(tsp.getId());
            }
        }
        return result;
    }

    public CertificateRefWrapper getKeyIdentifierReference() {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        certificateRefs.addAll(this.foundCertificates().getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin.KEY_IDENTIFIER));
        certificateRefs.addAll(this.foundCertificates().getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.KEY_IDENTIFIER));
        if (!certificateRefs.isEmpty()) {
            return (CertificateRefWrapper)certificateRefs.iterator().next();
        }
        return null;
    }

    public SignatureWrapper getParent() {
        XmlSignature parent = this.signature.getParent();
        if (parent != null) {
            return new SignatureWrapper(parent);
        }
        return null;
    }

    public List<XmlSignatureScope> getSignatureScopes() {
        return this.signature.getSignatureScopes();
    }

    public List<XmlSignerRole> getSignerRoles() {
        return this.signature.getSignerRole();
    }

    public List<XmlSignerRole> getClaimedRoles() {
        return this.getSignerRolesByCategory(EndorsementType.CLAIMED);
    }

    public List<XmlSignerRole> getCertifiedRoles() {
        return this.getSignerRolesByCategory(EndorsementType.CERTIFIED);
    }

    public List<XmlSignerRole> getSignedAssertions() {
        return this.getSignerRolesByCategory(EndorsementType.SIGNED);
    }

    public List<String> getSignerRoleDetails(List<XmlSignerRole> listOfSignerRoles) {
        ArrayList<String> roles = new ArrayList<String>();
        for (XmlSignerRole xmlSignerRole : listOfSignerRoles) {
            roles.add(xmlSignerRole.getRole());
        }
        return roles;
    }

    private List<XmlSignerRole> getSignerRolesByCategory(EndorsementType category) {
        ArrayList<XmlSignerRole> roles = new ArrayList<XmlSignerRole>();
        for (XmlSignerRole xmlSignerRole : this.getSignerRoles()) {
            if (!category.equals((Object)xmlSignerRole.getCategory())) continue;
            roles.add(xmlSignerRole);
        }
        return roles;
    }

    public List<XmlCommitmentTypeIndication> getCommitmentTypeIndications() {
        List<XmlCommitmentTypeIndication> commitmentTypeIndications = this.signature.getCommitmentTypeIndications();
        if (commitmentTypeIndications != null) {
            return commitmentTypeIndications;
        }
        return Collections.emptyList();
    }

    public boolean isPolicyPresent() {
        return this.signature.getPolicy() != null;
    }

    public String getPolicyProcessingError() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getProcessingError();
        }
        return "";
    }

    public String getPolicyDescription() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDescription() != null) {
            return policy.getDescription();
        }
        return "";
    }

    public List<String> getPolicyDocumentationReferences() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDocumentationReferences() != null) {
            return policy.getDocumentationReferences();
        }
        return Collections.emptyList();
    }

    public List<String> getPolicyTransforms() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getTransformations() != null) {
            return policy.getTransformations();
        }
        return Collections.emptyList();
    }

    public String getPolicyUrl() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getUrl();
        }
        return "";
    }

    public XmlUserNotice getPolicyUserNotice() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getUserNotice();
        }
        return null;
    }

    public XmlSPDocSpecification getPolicyDocSpecification() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.getDocSpecification();
        }
        return null;
    }

    public boolean isPolicyAsn1Processable() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isAsn1Processable() != null && policy.isAsn1Processable() != false;
        }
        return false;
    }

    public boolean isPolicyIdentified() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null) {
            return policy.isIdentified() != null && policy.isIdentified() != false;
        }
        return false;
    }

    public boolean isPolicyDigestValid() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDigestAlgoAndValue() != null) {
            return policy.getDigestAlgoAndValue().isMatch() != null && policy.getDigestAlgoAndValue().isMatch() != false;
        }
        return false;
    }

    public boolean isPolicyDigestAlgorithmsEqual() {
        XmlPolicy policy = this.signature.getPolicy();
        if (policy != null && policy.getDigestAlgoAndValue() != null) {
            return policy.getDigestAlgoAndValue().isDigestAlgorithmsEqual() != null && policy.getDigestAlgoAndValue().isDigestAlgorithmsEqual() != false;
        }
        return false;
    }

    public XmlPDFRevision getPDFRevision() {
        return this.signature.getPDFRevision();
    }

    public boolean arePdfModificationsDetected() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        return this.arePdfModificationsDetected(pdfRevision);
    }

    public List<BigInteger> getPdfAnnotationsOverlapConcernedPages() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        return this.getPdfAnnotationsOverlapConcernedPages(pdfRevision);
    }

    public List<BigInteger> getPdfVisualDifferenceConcernedPages() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        return this.getPdfVisualDifferenceConcernedPages(pdfRevision);
    }

    public List<BigInteger> getPdfPageDifferenceConcernedPages() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        return this.getPdfPageDifferenceConcernedPages(pdfRevision);
    }

    public boolean arePdfObjectModificationsDetected() {
        return this.getPdfObjectModifications(this.signature.getPDFRevision()) != null;
    }

    public List<XmlObjectModification> getPdfExtensionChanges() {
        return this.getPdfExtensionChanges(this.signature.getPDFRevision());
    }

    public List<XmlObjectModification> getPdfSignatureOrFormFillChanges() {
        return this.getPdfSignatureOrFormFillChanges(this.signature.getPDFRevision());
    }

    public List<XmlObjectModification> getPdfAnnotationChanges() {
        return this.getPdfAnnotationChanges(this.signature.getPDFRevision());
    }

    public List<XmlObjectModification> getPdfUndefinedChanges() {
        return this.getPdfUndefinedChanges(this.signature.getPDFRevision());
    }

    public List<String> getModifiedFieldNames() {
        return this.getModifiedFieldNames(this.signature.getPDFRevision());
    }

    public String getFirstFieldName() {
        List<XmlPDFSignatureField> fields;
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null && (fields = pdfRevision.getFields()) != null && !fields.isEmpty()) {
            return fields.iterator().next().getName();
        }
        return null;
    }

    public List<String> getSignatureFieldNames() {
        List<XmlPDFSignatureField> fields;
        ArrayList<String> names = new ArrayList<String>();
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null && (fields = pdfRevision.getFields()) != null && !fields.isEmpty()) {
            for (XmlPDFSignatureField signatureField : fields) {
                names.add(signatureField.getName());
            }
        }
        return names;
    }

    public List<XmlSignerInfo> getSignatureInformationStore() {
        return this.signature.getSignerInformationStore();
    }

    public String getSignerName() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getSignerName();
        }
        return null;
    }

    public String getSignatureDictionaryType() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getType();
        }
        return null;
    }

    public String getFilter() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getFilter();
        }
        return null;
    }

    public String getSubFilter() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getSubFilter();
        }
        return null;
    }

    public String getContactInfo() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getContactInfo();
        }
        return null;
    }

    public String getLocation() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getLocation();
        }
        return null;
    }

    public String getReason() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getReason();
        }
        return null;
    }

    public List<BigInteger> getSignatureByteRange() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getSignatureByteRange();
        }
        return Collections.emptyList();
    }

    public CertificationPermission getDocMDPPermissions() {
        XmlDocMDP docMDP;
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null && (docMDP = pdfRevision.getPDFSignatureDictionary().getDocMDP()) != null) {
            return docMDP.getPermissions();
        }
        return null;
    }

    public XmlPDFLockDictionary getFieldMDP() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getFieldMDP();
        }
        return null;
    }

    public XmlPDFLockDictionary getSigFieldLock() {
        XmlPDFRevision pdfRevision = this.signature.getPDFRevision();
        if (pdfRevision != null) {
            List<XmlPDFSignatureField> fields = pdfRevision.getFields();
            for (XmlPDFSignatureField field : fields) {
                XmlPDFLockDictionary sigFieldLock = field.getSigFieldLock();
                if (sigFieldLock == null) continue;
                return sigFieldLock;
            }
        }
        return null;
    }

    public byte[] getSignatureValue() {
        return this.signature.getSignatureValue();
    }

    public boolean isDocHashOnly() {
        XmlSignerDocumentRepresentations signerDocumentRepresentation = this.signature.getSignerDocumentRepresentations();
        if (signerDocumentRepresentation != null) {
            return signerDocumentRepresentation.isDocHashOnly();
        }
        return false;
    }

    public boolean isHashOnly() {
        XmlSignerDocumentRepresentations signerDocumentRepresentation = this.signature.getSignerDocumentRepresentations();
        if (signerDocumentRepresentation != null) {
            return signerDocumentRepresentation.isHashOnly();
        }
        return false;
    }

    @Override
    public byte[] getBinaries() {
        return this.signature.getSignatureValue();
    }
}

