/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSCompactSerializationParser;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JWSJsonSerializationParser;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class JWSConverter {
    private static final String FLATTENED_SERIALIZATION_DOCUMENT_NAME = "json-flattened-serialization.json";
    private static final String SERIALIZATION_DOCUMENT_NAME = "json-serialization.json";
    private static final String CLEAR_ETSIU_DOCUMENT_NAME = "etsiU-clear-incorporation.json";
    private static final String BASE64URL_ETSIU_DOCUMENT_NAME = "etsiU-base64url-incorporation.json";
    private static List<String> timestampHeaderNames = Arrays.asList("arcTst", "rfsTst", "sigRTst");

    private JWSConverter() {
    }

    public static DSSDocument fromJWSCompactToJSONFlattenedSerialization(DSSDocument document) {
        JWSCompactSerializationParser parser = new JWSCompactSerializationParser(document);
        JWS jws = parser.parse();
        JWSJsonSerializationObject jwsJsonSerializationObject = DSSJsonUtils.toJWSJsonSerializationObject(jws);
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, JWSSerializationType.FLATTENED_JSON_SERIALIZATION);
        DSSDocument signatureDocument = generator.generate();
        signatureDocument.setName(FLATTENED_SERIALIZATION_DOCUMENT_NAME);
        signatureDocument.setMimeType(MimeType.JSON);
        return signatureDocument;
    }

    public static DSSDocument fromJWSCompactToJSONSerialization(DSSDocument document) {
        JWSCompactSerializationParser parser = new JWSCompactSerializationParser(document);
        JWS jws = parser.parse();
        JWSJsonSerializationObject jwsJsonSerializationObject = DSSJsonUtils.toJWSJsonSerializationObject(jws);
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, JWSSerializationType.JSON_SERIALIZATION);
        DSSDocument signatureDocument = generator.generate();
        signatureDocument.setName(SERIALIZATION_DOCUMENT_NAME);
        signatureDocument.setMimeType(MimeType.JSON);
        return signatureDocument;
    }

    public static DSSDocument fromEtsiUWithBase64UrlToClearJsonIncorporation(DSSDocument document) {
        JWSJsonSerializationParser parser = new JWSJsonSerializationParser(document);
        JWSJsonSerializationObject jwsJsonSerializationObject = parser.parse();
        for (JWS jws : jwsJsonSerializationObject.getSignatures()) {
            List<Object> etsiUContent = DSSJsonUtils.getEtsiU(jws);
            if (Utils.isCollectionEmpty(etsiUContent)) continue;
            JWSConverter.assertConvertPossible(etsiUContent);
            List<Object> clearEtsiUContent = JWSConverter.toClearJsonIncorporation(etsiUContent);
            Map<String, Object> unprotected = jws.getUnprotected();
            unprotected.replace("etsiU", clearEtsiUContent);
        }
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
        DSSDocument signatureDocument = generator.generate();
        signatureDocument.setName(CLEAR_ETSIU_DOCUMENT_NAME);
        signatureDocument.setMimeType(MimeType.JSON);
        return signatureDocument;
    }

    private static void assertConvertPossible(List<Object> etsiUContent) {
        if (!DSSJsonUtils.checkComponentsUnicity(etsiUContent)) {
            throw new DSSException("Unable to convert the EtsiU content! All components shall have a common form.");
        }
    }

    private static List<Object> toClearJsonIncorporation(List<Object> etsiUContent) {
        ArrayList<Object> clearEtsiUContent = new ArrayList<Object>();
        for (Object item : etsiUContent) {
            Map<String, Object> clearEtsiUComponent = DSSJsonUtils.parseEtsiUComponent(item);
            if (clearEtsiUComponent == null) {
                throw new DSSException(String.format("Unable to parse 'etsiU' component : '%s'", item));
            }
            JWSConverter.assertComponentSupportsConversion(clearEtsiUComponent);
            clearEtsiUContent.add(new JsonObject(clearEtsiUComponent));
        }
        return clearEtsiUContent;
    }

    public static DSSDocument fromEtsiUWithClearJsonToBase64UrlIncorporation(DSSDocument document) {
        JWSJsonSerializationParser parser = new JWSJsonSerializationParser(document);
        JWSJsonSerializationObject jwsJsonSerializationObject = parser.parse();
        for (JWS jws : jwsJsonSerializationObject.getSignatures()) {
            List<Object> etsiUContent = DSSJsonUtils.getEtsiU(jws);
            if (Utils.isCollectionEmpty(etsiUContent)) continue;
            JWSConverter.assertConvertPossible(etsiUContent);
            List<Object> base64UrlEtsiUContent = JWSConverter.toBase64UrlIncorporation(etsiUContent);
            Map<String, Object> unprotected = jws.getUnprotected();
            unprotected.replace("etsiU", base64UrlEtsiUContent);
        }
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
        DSSDocument signatureDocument = generator.generate();
        signatureDocument.setName(BASE64URL_ETSIU_DOCUMENT_NAME);
        signatureDocument.setMimeType(MimeType.JSON);
        return signatureDocument;
    }

    private static List<Object> toBase64UrlIncorporation(List<Object> etsiUContent) {
        ArrayList<Object> base64UrlEtsiUContent = new ArrayList<Object>();
        for (Object item : etsiUContent) {
            Map<String, Object> base64UrlEtsiUComponent = DSSJsonUtils.parseEtsiUComponent(item);
            if (base64UrlEtsiUComponent == null) {
                throw new DSSException(String.format("Unable to parse 'etsiU' component : '%s'", item));
            }
            JWSConverter.assertComponentSupportsConversion(base64UrlEtsiUComponent);
            base64UrlEtsiUContent.add(DSSJsonUtils.toBase64Url(base64UrlEtsiUComponent));
        }
        return base64UrlEtsiUContent;
    }

    private static void assertComponentSupportsConversion(Map<String, Object> etsiUComponent) {
        String componentName = etsiUComponent.keySet().iterator().next();
        if (timestampHeaderNames.contains(componentName)) {
            throw new DSSException(String.format("Unable to convert a signature! 'etsiU' contains a component with name '%s', which is sensible to a format change.", componentName));
        }
    }
}

