/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESExtensionBuilder;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentValidator;
import eu.europa.esig.dss.jades.validation.JAdESDocumentValidatorFactory;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESSignaturePolicyStoreBuilder
extends JAdESExtensionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESSignaturePolicyStoreBuilder.class);

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore, boolean base64UrlInstance) {
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSignaturePolicyContent(), "Signature policy content must be provided");
        JAdESDocumentValidatorFactory documentValidatorFactory = new JAdESDocumentValidatorFactory();
        AbstractJWSDocumentValidator documentValidator = documentValidatorFactory.create(document);
        JWSJsonSerializationObject jwsJsonSerializationObject = documentValidator.getJwsJsonSerializationObject();
        this.assertJSONSerializationObjectMayBeExtended(jwsJsonSerializationObject);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), base64UrlInstance);
            this.extendSignature(jadesSignature, signaturePolicyStore, base64UrlInstance, documentValidator);
        }
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
        return generator.generate();
    }

    private void extendSignature(JAdESSignature jadesSignature, SignaturePolicyStore signaturePolicyStore, boolean base64UrlInstance, AbstractJWSDocumentValidator documentValidator) {
        SignaturePolicy signaturePolicy = jadesSignature.getSignaturePolicy();
        if (signaturePolicy != null && signaturePolicy.getDigest() != null) {
            signaturePolicy.setPolicyContent(signaturePolicyStore.getSignaturePolicyContent());
            Digest expectedDigest = signaturePolicy.getDigest();
            SignaturePolicyValidator signaturePolicyValidator = documentValidator.getSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
            Digest computedDigest = signaturePolicyValidator.getComputedDigest(signaturePolicyStore.getSignaturePolicyContent(), expectedDigest.getAlgorithm());
            if (expectedDigest.equals(computedDigest)) {
                LinkedHashMap<String, Object> sigPolicyStoreParams = new LinkedHashMap<String, Object>();
                sigPolicyStoreParams.put("sigPolDoc", Utils.toBase64(DSSUtils.toByteArray(signaturePolicyStore.getSignaturePolicyContent())));
                SpDocSpecification spDocSpecification = signaturePolicyStore.getSpDocSpecification();
                JsonObject oidObject = DSSJsonUtils.getOidObject(spDocSpecification.getId(), spDocSpecification.getDescription(), spDocSpecification.getDocumentationReferences());
                sigPolicyStoreParams.put("spDSpec", oidObject);
                JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
                etsiUHeader.addComponent("sigPSt", sigPolicyStoreParams, base64UrlInstance);
            } else {
                LOG.warn("Signature policy's digest doesn't match the document {} for signature {}", (Object)expectedDigest, (Object)jadesSignature.getId());
            }
        } else {
            LOG.warn("No SignaturePolicyIdentifier '{}' found for a signature with id '{}'!", (Object)"sigPId", (Object)jadesSignature.getId());
        }
    }
}

