/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JWSJsonSerializationParser;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentValidator;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWSSerializationDocumentValidator
extends AbstractJWSDocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JWSSerializationDocumentValidator.class);
    private List<AdvancedSignature> signatures;

    public JWSSerializationDocumentValidator() {
    }

    public JWSSerializationDocumentValidator(DSSDocument document) {
        super(document);
    }

    @Override
    public boolean isSupported(DSSDocument document) {
        JWSJsonSerializationParser jwsJsonSerializationParser = new JWSJsonSerializationParser(document);
        return jwsJsonSerializationParser.isSupported();
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures == null) {
            this.signatures = new ArrayList<AdvancedSignature>();
            JWSJsonSerializationObject jwsJsonSerializationObject = this.getJwsJsonSerializationObject();
            List<JWS> foundSignatures = jwsJsonSerializationObject.getSignatures();
            LOG.info("{} signature(s) found", (Object)Utils.collectionSize(foundSignatures));
            for (JWS jws : foundSignatures) {
                JAdESSignature jadesSignature = new JAdESSignature(jws);
                jadesSignature.setSignatureFilename(this.document.getName());
                jadesSignature.setSigningCertificateSource(this.signingCertificateSource);
                jadesSignature.setDetachedContents(this.detachedContents);
                jadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                this.signatures.add(jadesSignature);
            }
        }
        return this.signatures;
    }

    @Override
    protected JWSJsonSerializationObject buildJwsJsonSerializationObject() {
        JWSJsonSerializationParser jwsJsonSerializationParser = new JWSJsonSerializationParser(this.document);
        if (jwsJsonSerializationParser.isSupported()) {
            return jwsJsonSerializationParser.parse();
        }
        throw new IllegalInputException("The given document is not supported by JWSSerializationDocumentValidator!");
    }
}

