/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.PKIEncoding;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.jades.validation.JAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JAdESSignedProperties;
import eu.europa.esig.dss.jades.validation.timestamp.JAdESTimestampDataBuilder;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESTimestampSource
extends SignatureTimestampSource<JAdESSignature, JAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESTimestampSource.class);

    public JAdESTimestampSource(JAdESSignature signature) {
        super(signature);
    }

    @Override
    protected SignatureProperties<JAdESAttribute> buildSignedSignatureProperties() {
        return new JAdESSignedProperties(((JAdESSignature)this.signature).getJws().getHeaders());
    }

    @Override
    protected SignatureProperties<JAdESAttribute> buildUnsignedSignatureProperties() {
        return ((JAdESSignature)this.signature).getEtsiUHeader();
    }

    @Override
    protected boolean isContentTimestamp(JAdESAttribute signedAttribute) {
        return "adoTst".equals(signedAttribute.getHeaderName());
    }

    @Override
    protected boolean isAllDataObjectsTimestamp(JAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isIndividualDataObjectsTimestamp(JAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isSignatureTimestamp(JAdESAttribute unsignedAttribute) {
        return "sigTst".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isCompleteCertificateRef(JAdESAttribute unsignedAttribute) {
        return "xRefs".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isAttributeCertificateRef(JAdESAttribute unsignedAttribute) {
        return "axRefs".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isCompleteRevocationRef(JAdESAttribute unsignedAttribute) {
        return "rRefs".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isAttributeRevocationRef(JAdESAttribute unsignedAttribute) {
        return "arRefs".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isRefsOnlyTimestamp(JAdESAttribute unsignedAttribute) {
        return "rfsTst".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isSigAndRefsTimestamp(JAdESAttribute unsignedAttribute) {
        return "sigRTst".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isCertificateValues(JAdESAttribute unsignedAttribute) {
        return "xVals".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isRevocationValues(JAdESAttribute unsignedAttribute) {
        return "rVals".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isArchiveTimestamp(JAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestamp(unsignedAttribute.getHeaderName());
    }

    @Override
    private boolean isArchiveTimestamp(String headerName) {
        return "arcTst".equals(headerName);
    }

    @Override
    protected boolean isTimeStampValidationData(JAdESAttribute unsignedAttribute) {
        return "tstVD".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isCounterSignature(JAdESAttribute unsignedAttribute) {
        return "cSig".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isSignaturePolicyStore(JAdESAttribute unsignedAttribute) {
        return "sigPSt".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isAttrAuthoritiesCertValues(JAdESAttribute unsignedAttribute) {
        return "axVals".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected boolean isAttributeRevocationValues(JAdESAttribute unsignedAttribute) {
        return "arVals".equals(unsignedAttribute.getHeaderName());
    }

    @Override
    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List<TimestampedReference> timestampedReferences = super.getSignatureTimestampReferences();
        this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        return timestampedReferences;
    }

    @Override
    protected List<CertificateRef> getCertificateRefs(JAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        List<?> certRefs = DSSJsonUtils.toList(unsignedAttribute.getValue());
        if (Utils.isCollectionNotEmpty(certRefs)) {
            for (Object item : certRefs) {
                CertificateRef certificateRef;
                Map<?, ?> certId = DSSJsonUtils.toMap(item, "certId");
                if (!Utils.isMapNotEmpty(certId) || (certificateRef = JAdESCertificateRefExtractionUtils.createCertificateRef(certId)) == null) continue;
                result.add(certificateRef);
            }
        }
        return result;
    }

    @Override
    protected List<CRLRef> getCRLRefs(JAdESAttribute unsignedAttribute) {
        List<?> crlRefs;
        ArrayList<CRLRef> result = new ArrayList<CRLRef>();
        Map<?, ?> refsValueMap = DSSJsonUtils.toMap(unsignedAttribute.getValue());
        if (Utils.isMapNotEmpty(refsValueMap) && Utils.isCollectionNotEmpty(crlRefs = DSSJsonUtils.getAsList(refsValueMap, "crlRefs"))) {
            for (Object item : crlRefs) {
                CRLRef crlRef;
                Map<?, ?> crlRefMap = DSSJsonUtils.toMap(item);
                if (!Utils.isMapNotEmpty(crlRefMap) || (crlRef = JAdESRevocationRefExtractionUtils.createCRLRef(crlRefMap)) == null) continue;
                result.add(crlRef);
            }
        }
        return result;
    }

    @Override
    protected List<OCSPRef> getOCSPRefs(JAdESAttribute unsignedAttribute) {
        List<?> ocsp;
        ArrayList<OCSPRef> result = new ArrayList<OCSPRef>();
        Map<?, ?> refsValueMap = DSSJsonUtils.toMap(unsignedAttribute.getValue());
        if (Utils.isMapNotEmpty(refsValueMap) && Utils.isCollectionNotEmpty(ocsp = DSSJsonUtils.getAsList(refsValueMap, "ocspRefs"))) {
            for (Object item : ocsp) {
                OCSPRef ocspRef;
                Map<?, ?> ocspRefMap = DSSJsonUtils.toMap(item);
                if (!Utils.isMapNotEmpty(ocspRefMap) || (ocspRef = JAdESRevocationRefExtractionUtils.createOCSPRef(ocspRefMap)) == null) continue;
                result.add(ocspRef);
            }
        }
        return result;
    }

    @Override
    protected List<Identifier> getEncapsulatedCertificateIdentifiers(JAdESAttribute unsignedAttribute) {
        List<?> xVals = null;
        if (this.isTimeStampValidationData(unsignedAttribute)) {
            Map<?, ?> tstVd = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "tstVD");
            if (Utils.isMapNotEmpty(tstVd)) {
                xVals = DSSJsonUtils.getAsList(tstVd, "xVals");
            }
        } else {
            xVals = DSSJsonUtils.toList(unsignedAttribute.getValue(), "xVals");
        }
        if (Utils.isCollectionNotEmpty(xVals)) {
            ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
            for (Object encapsulatedCert : xVals) {
                try {
                    Map<?, ?> map = DSSJsonUtils.toMap(encapsulatedCert);
                    if (!Utils.isMapNotEmpty(map)) continue;
                    Map<?, ?> x509Cert = DSSJsonUtils.getAsMap(map, "x509Cert");
                    Map<?, ?> otherCert = DSSJsonUtils.getAsMap(map, "otherCert");
                    if (Utils.isMapNotEmpty(x509Cert)) {
                        String base64Cert = DSSJsonUtils.getAsString(x509Cert, "val");
                        if (!Utils.isStringNotBlank(base64Cert)) continue;
                        byte[] binaries = Utils.fromBase64(base64Cert);
                        CertificateToken certificateToken = DSSUtils.loadCertificate(binaries);
                        certificateIdentifiers.add(certificateToken.getDSSId());
                        continue;
                    }
                    if (!Utils.isMapNotEmpty(otherCert)) continue;
                    LOG.warn("The header '{}' is not supported! The entry is skipped.", (Object)"otherCert");
                }
                catch (Exception e) {
                    LOG.warn("An error occurred during parsing a certificate. Reason : {}", (Object)e.getMessage(), (Object)e);
                }
            }
            return certificateIdentifiers;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken timestampToken) {
        return Collections.emptyList();
    }

    @Override
    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(JAdESAttribute unsignedAttribute) {
        Map<?, ?> rVals = null;
        if (this.isTimeStampValidationData(unsignedAttribute)) {
            Map<?, ?> tstVd = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "rVals");
            if (Utils.isMapNotEmpty(tstVd)) {
                rVals = DSSJsonUtils.getAsMap(tstVd, "rVals");
            }
        } else {
            rVals = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "rVals");
        }
        if (rVals != null) {
            ArrayList<CRLBinary> crlIdentifiers = new ArrayList<CRLBinary>();
            List<?> crlVals = DSSJsonUtils.getAsList(rVals, "crlVals");
            if (Utils.isCollectionNotEmpty(crlVals)) {
                for (Object item : crlVals) {
                    try {
                        String base64Crl;
                        Map<?, ?> encapsulatedCrl = DSSJsonUtils.toMap(item);
                        if (!Utils.isMapNotEmpty(encapsulatedCrl) || !Utils.isStringNotBlank(base64Crl = DSSJsonUtils.getAsString(encapsulatedCrl, "val"))) continue;
                        byte[] binaries = Utils.fromBase64(base64Crl);
                        crlIdentifiers.add(CRLUtils.buildCRLBinary(binaries));
                    }
                    catch (Exception e) {
                        LOG.warn("An error occurred during parsing a CRL. Reason : {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            return crlIdentifiers;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(JAdESAttribute unsignedAttribute) {
        Map<?, ?> rVals = null;
        if (this.isTimeStampValidationData(unsignedAttribute)) {
            Map<?, ?> tstVd = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "rVals");
            if (Utils.isMapNotEmpty(tstVd)) {
                rVals = DSSJsonUtils.getAsMap(tstVd, "rVals");
            }
        } else {
            rVals = DSSJsonUtils.toMap(unsignedAttribute.getValue(), "rVals");
        }
        if (rVals != null) {
            ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
            List<?> ocspVals = DSSJsonUtils.getAsList(rVals, "ocspVals");
            if (Utils.isCollectionNotEmpty(ocspVals)) {
                for (Object item : ocspVals) {
                    try {
                        String base64Ocps;
                        Map<?, ?> encapsulatedOcsp = DSSJsonUtils.toMap(item);
                        if (!Utils.isMapNotEmpty(encapsulatedOcsp) || !Utils.isStringNotBlank(base64Ocps = DSSJsonUtils.getAsString(encapsulatedOcsp, "val"))) continue;
                        byte[] binaries = Utils.fromBase64(base64Ocps);
                        BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries(binaries);
                        ocspIdentifiers.add(OCSPResponseBinary.build(basicOCSPResp));
                    }
                    catch (Exception e) {
                        LOG.warn("An error occurred during parsing a CRL. Reason : {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            return ocspIdentifiers;
        }
        return Collections.emptyList();
    }

    @Override
    protected JAdESTimestampDataBuilder getTimestampDataBuilder() {
        return new JAdESTimestampDataBuilder((JAdESSignature)this.signature);
    }

    @Override
    protected List<AdvancedSignature> getCounterSignatures(JAdESAttribute unsignedAttribute) {
        EtsiUComponent etsiUComponent;
        JAdESSignature counterSignature;
        if (unsignedAttribute instanceof EtsiUComponent && (counterSignature = DSSJsonUtils.extractJAdESCounterSignature(etsiUComponent = (EtsiUComponent)unsignedAttribute, (JAdESSignature)this.signature)) != null) {
            return Collections.singletonList(counterSignature);
        }
        return Collections.emptyList();
    }

    public byte[] getSignatureTimestampData() {
        return this.getTimestampDataBuilder().getSignatureTimestampData();
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.getTimestampDataBuilder().getArchiveTimestampData(canonicalizationMethod);
    }

    @Override
    protected TimestampToken makeTimestampToken(JAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        throw new UnsupportedOperationException("Attribute can contain more than one timestamp");
    }

    @Override
    protected List<TimestampToken> makeTimestampTokens(JAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        if (TimestampType.ARCHIVE_TIMESTAMP.equals((Object)timestampType)) {
            return this.extractArchiveTimestampTokens(signatureAttribute, references);
        }
        Map<?, ?> tstContainer = DSSJsonUtils.toMap(signatureAttribute.getValue(), "tstContainer");
        return this.extractTimestampTokens(signatureAttribute, tstContainer, timestampType, references);
    }

    private List<TimestampToken> extractTimestampTokens(JAdESAttribute signatureAttribute, Map<?, ?> tstContainer, TimestampType timestampType, List<TimestampedReference> references) {
        LinkedList<TimestampToken> result = new LinkedList<TimestampToken>();
        if (Utils.isMapNotEmpty(tstContainer)) {
            List<?> tstTokens = DSSJsonUtils.getAsList(tstContainer, "tstTokens");
            if (Utils.isCollectionNotEmpty(tstTokens)) {
                for (Object item : tstTokens) {
                    Map<?, ?> tstToken = DSSJsonUtils.toMap(item);
                    if (!Utils.isMapNotEmpty(tstToken)) continue;
                    String encoding = DSSJsonUtils.getAsString(tstToken, "encoding");
                    if (Utils.isStringEmpty(encoding) || Utils.areStringsEqual(PKIEncoding.DER.getUri(), encoding)) {
                        String tstBase64 = DSSJsonUtils.getAsString(tstToken, "val");
                        if (!Utils.isStringNotEmpty(tstBase64)) continue;
                        try {
                            TimestampToken timestampToken = new TimestampToken(Utils.fromBase64(tstBase64), timestampType, references);
                            timestampToken.setTimestampAttribute(signatureAttribute);
                            result.add(timestampToken);
                        }
                        catch (Exception e) {
                            LOG.error("Unable to parse timestamp '{}'", (Object)tstBase64, (Object)e);
                        }
                        continue;
                    }
                    LOG.warn("Unsupported encoding {}", (Object)encoding);
                }
            } else {
                LOG.warn("'{}' element is not found! Returns an empty array if timestamps.", (Object)"tstTokens");
            }
        }
        return result;
    }

    private List<TimestampToken> extractArchiveTimestampTokens(JAdESAttribute signatureAttribute, List<TimestampedReference> references) {
        Map<?, ?> arcTst = DSSJsonUtils.toMap(signatureAttribute.getValue(), "arcTst");
        return this.extractTimestampTokens(signatureAttribute, arcTst, TimestampType.ARCHIVE_TIMESTAMP, references);
    }

    @Override
    protected ArchiveTimestampType getArchiveTimestampType(JAdESAttribute unsignedAttribute) {
        return ArchiveTimestampType.JAdES;
    }
}

