/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.x509;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public abstract class Token
implements IdentifierBasedObject,
Serializable {
    private TokenIdentifier tokenIdentifier;
    protected PublicKey publicKeyOfTheSigner;
    protected SignatureValidity signatureValidity = SignatureValidity.NOT_EVALUATED;
    protected String signatureInvalidityReason = "";
    protected SignatureAlgorithm signatureAlgorithm;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDSSId() == null ? 0 : this.getDSSId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        return !(this.getDSSId() == null ? other.getDSSId() != null : !this.getDSSId().equals(other.getDSSId()));
    }

    public boolean isSelfSigned() {
        return false;
    }

    @Override
    public TokenIdentifier getDSSId() {
        if (this.tokenIdentifier == null) {
            this.tokenIdentifier = this.buildTokenIdentifier();
        }
        return this.tokenIdentifier;
    }

    protected abstract TokenIdentifier buildTokenIdentifier();

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public synchronized boolean isSignedBy(CertificateToken token) {
        return this.isSignedBy(token.getPublicKey());
    }

    public synchronized boolean isSignedBy(PublicKey publicKey) {
        if (this.publicKeyOfTheSigner != null) {
            return this.publicKeyOfTheSigner.equals(publicKey);
        }
        if (SignatureValidity.VALID == this.checkIsSignedBy(publicKey)) {
            if (!this.isSelfSigned()) {
                this.publicKeyOfTheSigner = publicKey;
            }
            return true;
        }
        return false;
    }

    protected abstract SignatureValidity checkIsSignedBy(PublicKey var1);

    public abstract X500Principal getIssuerX500Principal();

    public abstract Date getCreationDate();

    public String getAbbreviation() {
        return "?";
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public SignatureValidity getSignatureValidity() {
        return this.signatureValidity;
    }

    public PublicKey getPublicKeyOfTheSigner() {
        return this.publicKeyOfTheSigner;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public abstract byte[] getEncoded();

    public byte[] getDigest(DigestAlgorithm digestAlgorithm) {
        return this.getDSSId().getDigestValue(digestAlgorithm);
    }
}

