/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.AbstractDSSFont;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;

public class DSSFileFont
extends AbstractDSSFont {
    private static final long serialVersionUID = -2631152291035404442L;
    private static final String DEFAULT_FONT_NAME = "PTSerifRegular.ttf";
    private static final DSSDocument DEFAULT_FONT = new InMemoryDocument(SignatureImageTextParameters.class.getResourceAsStream("/fonts/PTSerifRegular.ttf"), "PTSerifRegular.ttf");
    private static final String DEFAULT_FONT_EXTENSION = ".ttf";
    private DSSDocument fileFont;
    private Font javaFont;

    public static DSSFileFont initializeDefault() {
        return new DSSFileFont(DEFAULT_FONT);
    }

    public DSSFileFont(InputStream inputStream) {
        this(new InMemoryDocument(inputStream));
    }

    public DSSFileFont(DSSDocument dssDocument) {
        this(dssDocument, 12.0f);
    }

    public DSSFileFont(DSSDocument dssDocument, float size) {
        this.fileFont = dssDocument;
        this.size = size;
        this.initFontName(dssDocument);
    }

    private void initFontName(DSSDocument fileFont) {
        if (Utils.isStringBlank(fileFont.getName())) {
            fileFont.setName(DSSUtils.getMD5Digest(DSSUtils.toByteArray(fileFont)) + DEFAULT_FONT_EXTENSION);
        }
    }

    @Override
    public Font getJavaFont() {
        if (this.javaFont == null) {
            this.javaFont = this.deriveJavaFont();
        }
        return this.javaFont;
    }

    private Font deriveJavaFont() {
        Font font;
        block8: {
            InputStream is = this.fileFont.openStream();
            try {
                Font font2 = Font.createFont(0, is);
                font = font2.deriveFont(this.size);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new DSSException(String.format("The Java font cannot be instantiated. Reason : %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return font;
    }

    public InputStream getInputStream() {
        return this.fileFont.openStream();
    }

    public String getName() {
        return this.fileFont.getName();
    }
}

