/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.List;

class PAdESLevelBaselineLT
extends PAdESLevelBaselineT {
    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        super(tspSource, certificateVerifier, pdfObjectFactory);
    }

    @Override
    protected DSSDocument extendSignatures(DSSDocument document, PDFDocumentValidator documentValidator, PAdESSignatureParameters parameters) {
        DSSDocument extendedDocument = super.extendSignatures(document, documentValidator, parameters);
        if (extendedDocument != document) {
            documentValidator = this.getPDFDocumentValidator(extendedDocument, parameters);
        }
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        this.assertExtendSignaturePossible(signatures, parameters);
        List<TimestampToken> detachedTimestamps = documentValidator.getDetachedTimestamps();
        ValidationDataContainer validationData = documentValidator.getValidationData(signatures, detachedTimestamps);
        PDFSignatureService signatureService = this.newPdfSignatureService();
        return signatureService.addDssDictionary(extendedDocument, (PdfValidationDataContainer)validationData, parameters.getPasswordProtection());
    }

    private void assertExtendSignaturePossible(List<AdvancedSignature> signatures, PAdESSignatureParameters parameters) {
        for (AdvancedSignature signature : signatures) {
            PAdESSignature padesSignature = (PAdESSignature)signature;
            SignatureLevel signatureLevel = parameters.getSignatureLevel();
            if (SignatureLevel.PAdES_BASELINE_LT.equals((Object)signatureLevel) && padesSignature.hasLTAProfile()) {
                throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LTA level.", new Object[]{signatureLevel}));
            }
            if (!padesSignature.areAllSelfSignedCertificates()) continue;
            throw new IllegalInputException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

