/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.signature.PAdESExtensionService;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLT;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLTA;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.signature.PadesCMSSignedDataBuilder;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESService
extends AbstractSignatureService<PAdESSignatureParameters, PAdESTimestampParameters> {
    private static final long serialVersionUID = -6518552348520127617L;
    private static final Logger LOG = LoggerFactory.getLogger(PAdESService.class);
    private final PadesCMSSignedDataBuilder padesCMSSignedDataBuilder;
    private IPdfObjFactory pdfObjFactory = new ServiceLoaderPdfObjFactory();

    public PAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.padesCMSSignedDataBuilder = new PadesCMSSignedDataBuilder(certificateVerifier);
        LOG.debug("+ PAdESService created");
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjFactory = pdfObjFactory;
    }

    private SignatureExtension<PAdESSignatureParameters> getExtensionProfile(SignatureLevel signatureLevel) {
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case PAdES_BASELINE_B: {
                return null;
            }
            case PAdES_BASELINE_T: {
                return new PAdESLevelBaselineT(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
            case PAdES_BASELINE_LT: {
                return new PAdESLevelBaselineLT(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
            case PAdES_BASELINE_LTA: {
                return new PAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier, this.pdfObjFactory);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{signatureLevel}));
    }

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocument);
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newContentTimestampService();
        DigestAlgorithm digestAlgorithm = parameters.getContentTimestampParameters().getDigestAlgorithm();
        byte[] messageDigest = pdfSignatureService.digest(toSignDocument, parameters);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, messageDigest);
        try {
            return new TimestampToken(timeStampResponse.getBytes(), TimestampType.CONTENT_TIMESTAMP);
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot obtain the content timestamp", e);
        }
    }

    public DSSDocument previewPageWithVisualSignature(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.previewPageWithVisualSignature(toSignDocument, parameters);
    }

    public DSSDocument previewSignatureField(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.previewSignatureField(toSignDocument, parameters);
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, PAdESSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocument);
        this.assertSigningCertificateValid(parameters);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        byte[] messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest);
        CMSUtils.generateDetachedCMSSignedData(generator, content);
        byte[] dataToSign = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(dataToSign);
    }

    protected byte[] computeDocumentDigest(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.digest(toSignDocument, parameters);
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocument);
        this.assertSigningCertificateValid(parameters);
        signatureValue = this.ensureSignatureValue(parameters.getSignatureAlgorithm(), signatureValue);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        byte[] encodedData = this.generateCMSSignedData(toSignDocument, parameters, signatureValue);
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newPAdESSignatureService();
        DSSDocument signature = pdfSignatureService.sign(toSignDocument, encodedData, parameters);
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(signatureLevel);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B && signatureLevel != SignatureLevel.PAdES_BASELINE_T && extension != null) {
            signature = extension.extendSignatures(signature, parameters);
        }
        parameters.reinit();
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        return signature;
    }

    private void assertSignaturePossible(DSSDocument toSignDocument) {
        if (toSignDocument instanceof DigestDocument) {
            throw new IllegalArgumentException("DigestDocument cannot be used for PAdES!");
        }
    }

    protected byte[] generateCMSSignedData(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        byte[] messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest);
        CMSSignedData data = CMSUtils.generateDetachedCMSSignedData(generator, content);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B) {
            CAdESLevelBaselineT cadesLevelBaselineT = new CAdESLevelBaselineT(this.tspSource, this.certificateVerifier);
            data = cadesLevelBaselineT.extendCMSSignatures(data, parameters);
        }
        return DSSASN1Utils.getDEREncoded(data);
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, PAdESSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        if (SignatureLevel.PAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{parameters.getSignatureLevel()}));
        }
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(parameters.getSignatureLevel());
        if (extension != null) {
            DSSDocument extended = extension.extendSignatures(toExtendDocument, parameters);
            extended.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            return extended;
        }
        return toExtendDocument;
    }

    public List<String> getAvailableSignatureFields(DSSDocument document) {
        return this.getAvailableSignatureFields(document, null);
    }

    public List<String> getAvailableSignatureFields(DSSDocument document, String passwordProtection) {
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.getAvailableSignatureFields(document, passwordProtection);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        return this.addNewSignatureField(document, parameters, null);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters, String passwordProtection) {
        PDFSignatureService pdfSignatureService = this.pdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.addNewSignatureField(document, parameters, passwordProtection);
    }

    @Override
    public DSSDocument timestamp(DSSDocument toTimestampDocument, PAdESTimestampParameters parameters) {
        PAdESExtensionService extensionService = new PAdESExtensionService(this.certificateVerifier, this.pdfObjFactory);
        DSSDocument extendedDocument = extensionService.incorporateValidationData(toTimestampDocument, parameters.getPasswordProtection());
        PAdESTimestampService timestampService = new PAdESTimestampService(this.tspSource, this.pdfObjFactory.newSignatureTimestampService());
        DSSDocument timestampedDocument = timestampService.timestampDocument(extendedDocument, parameters);
        timestampedDocument.setName(this.getFinalFileName(toTimestampDocument, SigningOperation.TIMESTAMP, null));
        return timestampedDocument;
    }
}

