/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pades.validation.scope.PAdESSignatureScopeFinder;
import eu.europa.esig.dss.pades.validation.scope.PAdESTimestampScopeFinder;
import eu.europa.esig.dss.pades.validation.timestamp.PdfRevisionTimestampSource;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PDFDocumentValidator
extends SignedDocumentValidator {
    private IPdfObjFactory pdfObjectFactory = new ServiceLoaderPdfObjFactory();
    private List<PdfRevision> documentRevisions;
    private String passwordProtection;

    PDFDocumentValidator() {
    }

    public PDFDocumentValidator(DSSDocument document) {
        super(new PAdESSignatureScopeFinder());
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        if (!this.isSupported(document)) {
            throw new IllegalInputException("Not supported document");
        }
        this.document = document;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return PAdESUtils.isPDFDocument(dssDocument);
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjectFactory = pdfObjFactory;
    }

    public void setPasswordProtection(String pwd) {
        this.passwordProtection = pwd;
    }

    @Override
    protected <T extends AdvancedSignature> ValidationContext prepareValidationContext(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        ValidationContext validationContext = super.prepareValidationContext(signatures, detachedTimestamps);
        List<PdfDocDssRevision> dssRevisions = this.getDssRevisions();
        this.prepareDssDictionaryValidationContext(validationContext, dssRevisions);
        return validationContext;
    }

    @Override
    protected PAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new PAdESDiagnosticDataBuilder();
    }

    protected void prepareDssDictionaryValidationContext(ValidationContext validationContext, List<PdfDocDssRevision> dssRevisions) {
        for (PdfDocDssRevision dssRevision : dssRevisions) {
            validationContext.addDocumentCertificateSource(dssRevision.getCertificateSource());
            validationContext.addDocumentCRLSource(dssRevision.getCRLSource());
            validationContext.addDocumentOCSPSource(dssRevision.getOCSPSource());
        }
    }

    @Override
    protected List<AdvancedSignature> getAllSignatures() {
        List<AdvancedSignature> allSignatures = super.getAllSignatures();
        this.postProcessing(allSignatures);
        return allSignatures;
    }

    protected void postProcessing(List<AdvancedSignature> signatures) {
        PDFSignatureService pdfSignatureService = this.pdfObjectFactory.newPAdESSignatureService();
        pdfSignatureService.analyzePdfModifications(this.document, signatures, this.passwordProtection);
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        ArrayList<PAdESSignature> signatures = new ArrayList<PAdESSignature>();
        ListCertificateSource dssCertificateSource = new ListCertificateSource();
        ListRevocationSource<CRL> dssCRLSource = new ListRevocationSource<CRL>();
        ListRevocationSource<OCSP> dssOCSPSource = new ListRevocationSource<OCSP>();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (pdfRevision instanceof PdfDocDssRevision) {
                PdfDocDssRevision docDssRevision = (PdfDocDssRevision)pdfRevision;
                dssCertificateSource.add(docDssRevision.getCertificateSource());
                dssCRLSource.add(docDssRevision.getCRLSource());
                dssOCSPSource.add(docDssRevision.getOCSPSource());
                continue;
            }
            if (!(pdfRevision instanceof PdfSignatureRevision)) continue;
            PdfSignatureRevision pdfSignatureRevision = (PdfSignatureRevision)pdfRevision;
            try {
                PAdESSignature padesSignature = new PAdESSignature(pdfSignatureRevision, this.documentRevisions);
                padesSignature.setSignatureFilename(this.document.getName());
                padesSignature.setSigningCertificateSource(this.signingCertificateSource);
                ListCertificateSource listCertificateSource = new ListCertificateSource();
                listCertificateSource.addAll(dssCertificateSource);
                padesSignature.setDssCertificateSource(listCertificateSource);
                ListRevocationSource<CRL> listCRLSource = new ListRevocationSource<CRL>();
                listCRLSource.addAll(dssCRLSource);
                padesSignature.setDssCRLSource(listCRLSource);
                ListRevocationSource<OCSP> listOCSPSource = new ListRevocationSource<OCSP>();
                listOCSPSource.addAll(dssOCSPSource);
                padesSignature.setDssOCSPSource(listOCSPSource);
                if (this.certificateVerifier != null) {
                    padesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                }
                signatures.add(padesSignature);
            }
            catch (Exception e) {
                throw new DSSException(String.format("Unable to collect a signature. Reason : [%s]", e.getMessage()), e);
            }
        }
        return Utils.reverseList(signatures);
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        ArrayList<TimestampedReference> coveredReferences = new ArrayList<TimestampedReference>();
        ListCertificateSource certificateSource = new ListCertificateSource();
        ListRevocationSource<CRL> crlSource = new ListRevocationSource<CRL>();
        ListRevocationSource<OCSP> ocspSource = new ListRevocationSource<OCSP>();
        for (PdfRevision pdfRevision : Utils.reverseList(this.getRevisions())) {
            if (pdfRevision instanceof PdfDocTimestampRevision) {
                PdfDocTimestampRevision pdfDocTimestampRevision = (PdfDocTimestampRevision)pdfRevision;
                TimestampToken timestampToken = this.createPdfTimestampToken(pdfDocTimestampRevision);
                certificateSource.add(timestampToken.getCertificateSource());
                crlSource.add(timestampToken.getCRLSource());
                ocspSource.add(timestampToken.getOCSPSource());
                DSSUtils.enrichCollection(timestampToken.getTimestampedReferences(), coveredReferences);
                timestamps.add(timestampToken);
            } else if (pdfRevision instanceof PdfDocDssRevision) {
                PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)pdfRevision;
                certificateSource.add(pdfDocDssRevision.getCertificateSource());
                crlSource.add(pdfDocDssRevision.getCRLSource());
                ocspSource.add(pdfDocDssRevision.getOCSPSource());
            } else if (pdfRevision instanceof PdfSignatureRevision) break;
            PdfRevisionTimestampSource pdfRevisionTimestampSource = new PdfRevisionTimestampSource(pdfRevision, certificateSource, crlSource, ocspSource);
            coveredReferences.addAll(pdfRevisionTimestampSource.getIncorporatedReferences());
        }
        return timestamps;
    }

    private TimestampToken createPdfTimestampToken(PdfDocTimestampRevision pdfDocTimestampRevision) {
        try {
            PdfTimestampToken timestampToken = pdfDocTimestampRevision.getTimestampToken();
            timestampToken.setFileName(this.document.getName());
            PAdESTimestampScopeFinder timestampScopeFinder = this.getPAdESTimestampScopeFinder();
            timestampScopeFinder.setDefaultDigestAlgorithm(this.getDefaultDigestAlgorithm());
            this.findTimestampScopes(timestampToken, timestampScopeFinder);
            return timestampToken;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to create a timestamp for a revision : %s. Reason : [%s]", pdfDocTimestampRevision.getByteRange(), e.getMessage()), e);
        }
    }

    @Override
    public <T extends AdvancedSignature> void findSignatureScopes(Collection<T> allSignatures) {
        super.findSignatureScopes(allSignatures);
        for (AdvancedSignature signature : allSignatures) {
            PAdESTimestampScopeFinder timestampScopeFinder = this.getPAdESTimestampScopeFinder();
            this.prepareTimestampScopeFinder(timestampScopeFinder, signature);
            for (TimestampToken timestampToken : signature.getDocumentTimestamps()) {
                this.findTimestampScopes(timestampToken, timestampScopeFinder);
            }
        }
    }

    protected PAdESTimestampScopeFinder getPAdESTimestampScopeFinder() {
        return new PAdESTimestampScopeFinder();
    }

    public List<PdfDssDict> getDssDictionaries() {
        ArrayList<PdfDssDict> dssDicts = new ArrayList<PdfDssDict>();
        for (PdfDocDssRevision dssRevision : this.getDssRevisions()) {
            dssDicts.add(dssRevision.getDssDictionary());
        }
        return dssDicts;
    }

    protected List<PdfDocDssRevision> getDssRevisions() {
        ArrayList<PdfDocDssRevision> dssRevisions = new ArrayList<PdfDocDssRevision>();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (!(pdfRevision instanceof PdfDocDssRevision)) continue;
            dssRevisions.add((PdfDocDssRevision)pdfRevision);
        }
        return Utils.reverseList(dssRevisions);
    }

    protected List<PdfRevision> getRevisions() {
        if (this.documentRevisions == null) {
            PDFSignatureService pdfSignatureService = this.pdfObjectFactory.newPAdESSignatureService();
            this.documentRevisions = pdfSignatureService.getRevisions(this.document, this.passwordProtection);
        }
        return this.documentRevisions;
    }

    @Override
    public <T extends AdvancedSignature> PdfValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        return (PdfValidationDataContainer)super.getValidationData(signatures, detachedTimestamps);
    }

    @Override
    protected PdfValidationDataContainer instantiateValidationDataContainer() {
        return new PdfValidationDataContainer(this.getDssRevisions());
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        PAdESSignature padesSignature = (PAdESSignature)advancedSignature;
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        InMemoryDocument originalPDF = PAdESUtils.getOriginalPDF(padesSignature);
        if (originalPDF != null && originalPDF.getBytes().length != 0) {
            result.add(originalPDF);
        }
        return result;
    }
}

