/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.dss.PdfCompositeDssDictCertificateSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PdfDssDictCertificateSource
extends TokenCertificateSource {
    private static final long serialVersionUID = 7254611440571170316L;
    private final PdfCompositeDssDictCertificateSource compositeCertificateSource;
    private final PdfDssDict dssDictionary;
    private final String relatedVRIDictionaryName;

    public PdfDssDictCertificateSource(PdfCompositeDssDictCertificateSource compositeCertificateSource, PdfDssDict dssDictionary) {
        this(compositeCertificateSource, dssDictionary, null);
    }

    public PdfDssDictCertificateSource(PdfCompositeDssDictCertificateSource compositeCertificateSource, PdfDssDict dssDictionary, String vriDictionaryName) {
        this.compositeCertificateSource = compositeCertificateSource;
        this.dssDictionary = dssDictionary;
        this.relatedVRIDictionaryName = vriDictionaryName;
        this.extractFromDssDictSource();
    }

    private void extractFromDssDictSource() {
        for (CertificateToken certToken : this.getDSSDictionaryCertValues()) {
            this.addCertificate(certToken, CertificateOrigin.DSS_DICTIONARY);
        }
        for (CertificateToken certToken : this.getVRIDictionaryCertValues()) {
            this.addCertificate(certToken, CertificateOrigin.VRI_DICTIONARY);
        }
    }

    public Map<Long, CertificateToken> getCertificateMap() {
        if (this.dssDictionary != null) {
            Map<Long, CertificateToken> dssCerts = this.dssDictionary.getCERTs();
            List<PdfVRIDict> vriDicts = PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName);
            for (PdfVRIDict vriDict : vriDicts) {
                dssCerts.putAll(vriDict.getCERTs());
            }
            return dssCerts;
        }
        return Collections.emptyMap();
    }

    public List<CertificateToken> getDSSDictionaryCertValues() {
        if (this.dssDictionary != null) {
            return this.getCertificatesByKeys(this.dssDictionary.getCERTs().keySet());
        }
        return Collections.emptyList();
    }

    public List<CertificateToken> getVRIDictionaryCertValues() {
        if (this.dssDictionary != null) {
            HashSet<Long> certKeys = new HashSet<Long>();
            List<PdfVRIDict> vris = PAdESUtils.getVRIsWithName(this.dssDictionary, this.relatedVRIDictionaryName);
            for (PdfVRIDict vri : vris) {
                certKeys.addAll(vri.getCERTs().keySet());
            }
            return this.getCertificatesByKeys(certKeys);
        }
        return Collections.emptyList();
    }

    private List<CertificateToken> getCertificatesByKeys(Collection<Long> objectIds) {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        for (Long objectId : objectIds) {
            certificateTokens.addAll(this.compositeCertificateSource.getCertificateTokensByObjectId(objectId));
        }
        return certificateTokens;
    }
}

